/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.evaluation;

public class PerformanceMeasure {
    public double tp;
    public double fp;
    public double tn;
    public double fn;

    public double getCorrelationCoefficient() {
        return (this.tp * this.tn - this.fp * this.fn) / Math.sqrt((this.tp + this.fp) * (this.tp + this.fn) * (this.tn + this.fp) * (this.tn + this.fn));
    }

    public double getCost() {
        return this.fp / this.tp;
    }

    public PerformanceMeasure(double tp, double tn, double fp, double fn) {
        this.tp = tp;
        this.tn = tn;
        this.fp = fp;
        this.fn = fn;
    }

    public PerformanceMeasure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public double getTPRate() {
        return this.tp / (this.tp + this.fn);
    }

    public double getTNRate() {
        return this.tn / (this.tn + this.fp);
    }

    public double getFNRate() {
        return this.fn / (this.tp + this.fn);
    }

    public double getFPRate() {
        return this.fp / (this.fp + this.tn);
    }

    public double getErrorRate() {
        return (this.fp + this.fn) / this.getTotal();
    }

    public double getAccuracy() {
        return (this.tp + this.tn) / this.getTotal();
    }

    public double getRecall() {
        return this.tp / (this.tp + this.fn);
    }

    public double getPrecision() {
        return this.tp / (this.tp + this.fp);
    }

    public double getCorrelation() {
        return (this.tp * this.tn + this.fp * this.fn) / Math.sqrt((this.tn + this.fn) * (this.tp + this.fp) * (this.tn + this.fp) * (this.fn + this.tp));
    }

    public double getFMeasure() {
        return this.getFMeasure(1);
    }

    public double getFMeasure(int beta) {
        double f = (double)(beta * beta + 1) * this.getPrecision() * this.getRecall() / ((double)(beta * beta) * this.getPrecision() + this.getRecall());
        if (Double.isNaN(f)) {
            return 0.0;
        }
        return f;
    }

    public double getQ9() {
        if (this.tp + this.fn == 0.0) {
            return (this.tn - this.fp) / (this.tn + this.fp);
        }
        if (this.tn + this.fp == 0.0) {
            return (this.tp - this.fn) / (this.tp + this.fn);
        }
        return 1.0 - Math.sqrt(2.0) * Math.sqrt(Math.pow(this.fn / (this.tp + this.fn), 2.0) + Math.pow(this.fp / (this.tn + this.fp), 2.0));
    }

    public double getBCR() {
        if (this.tn == 0.0 && this.fp == 0.0) {
            return this.tp / (this.tp + this.fn);
        }
        if (this.tp == 0.0 && this.fn == 0.0) {
            return this.tn / (this.tn + this.fp);
        }
        return 0.5 * (this.tp / (this.tp + this.fn) + this.tn / (this.tn + this.fp));
    }

    public String toString() {
        return "[TP=" + this.tp + ", FP=" + this.fp + ", TN=" + this.tn + ", FN=" + this.fn + "]";
    }

    public double getTotal() {
        return this.fn + this.fp + this.tn + this.tp;
    }
}

