/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.meta;

import be.abeel.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.sampling.Sampling;

public class Bagging
extends AbstractClassifier {
    private static final long serialVersionUID = 5571842927861670307L;
    private Classifier[] classifiers;
    private Dataset dataReference = null;
    private Sampling samplingMethod = Sampling.NormalBootstrapping;
    private long seed;
    private boolean calculateOutOfBagErrorEstimate = false;
    private double outOfBagErrorEstimate;

    @Deprecated
    public Bagging(Classifier[] classifiers, Random rg) {
        this.classifiers = classifiers;
        this.seed = rg.nextLong();
    }

    public Bagging(Classifier[] classifiers, Sampling s, long seed) {
        this.classifiers = classifiers;
        this.seed = seed;
        this.samplingMethod = s;
    }

    public void setCalculateOutOfBagErrorEstimate(boolean b) {
        this.calculateOutOfBagErrorEstimate = b;
    }

    public double getOutOfBagErrorEstimate() {
        return this.outOfBagErrorEstimate;
    }

    @Override
    public void buildClassifier(Dataset data) {
        this.dataReference = data;
        int t = 0;
        int f = 0;
        for (int i = 0; i < this.classifiers.length; ++i) {
            Pair<Dataset, Dataset> sample = this.samplingMethod.sample(data, data.size(), this.seed++);
            this.classifiers[i].buildClassifier((Dataset)sample.x());
            if (!this.calculateOutOfBagErrorEstimate) continue;
            for (Instance inst : (Dataset)sample.y()) {
                Object predClass = this.classifiers[i].classify(inst);
                if (predClass.equals(inst.classValue())) {
                    ++t;
                    continue;
                }
                ++f;
            }
            this.outOfBagErrorEstimate = t / (t + f);
        }
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        HashMap<Object, Double> membership = new HashMap<Object, Double>();
        for (Object e : this.dataReference.classes()) {
            membership.put(e, 0.0);
        }
        for (int i = 0; i < this.classifiers.length; ++i) {
            Object object = this.classifiers[i].classify(instance);
            membership.put(object, (Double)membership.get(object) + 1.0 / (double)this.classifiers.length);
        }
        return membership;
    }
}

