/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.clustering.FarthestFirst;
import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class IterativeFarthestFirst
implements Clusterer {
    private DistanceMeasure dm;
    private ClusterEvaluation ce;
    private int kMin;
    private int kMax;

    public IterativeFarthestFirst(ClusterEvaluation ce) {
        this(2, 6, new EuclideanDistance(), ce);
    }

    public IterativeFarthestFirst(int kMin, int kMax, DistanceMeasure dm, ClusterEvaluation ce) {
        this.kMin = kMin;
        this.kMax = kMax;
        this.dm = dm;
        this.ce = ce;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        FarthestFirst ff = new FarthestFirst(this.kMin, this.dm);
        Dataset[] bestClusters = ff.cluster(data);
        double bestScore = this.ce.score(bestClusters);
        for (int i = this.kMin + 1; i <= this.kMax; ++i) {
            ff = new FarthestFirst(i, this.dm);
            Dataset[] tmp = ff.cluster(data);
            double tmpScore = this.ce.score(tmp);
            if (!this.ce.compareScore(bestScore, tmpScore)) continue;
            bestScore = tmpScore;
            bestClusters = tmp;
        }
        return bestClusters;
    }
}

