/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class CIndex
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public CIndex(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] clusters) {
        double dw = 0.0;
        double minDw = Double.MAX_VALUE;
        double maxDw = Double.MIN_VALUE;
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < clusters[i].size(); ++j) {
                Instance x = clusters[i].instance(j);
                for (int k = j + 1; k < clusters[i].size(); ++k) {
                    Instance y = clusters[i].instance(k);
                    double distance = this.dm.measure(x, y);
                    dw += distance;
                    if (maxDw < distance) {
                        maxDw = distance;
                    }
                    if (!(minDw > distance)) continue;
                    minDw = distance;
                }
            }
        }
        double cIndex = (dw - minDw) / (maxDw - minDw);
        return cIndex;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

