/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class Gamma
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public Gamma(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        int k;
        Instance x;
        int j;
        int i;
        double maxIntraDist = Double.MIN_VALUE;
        double sPlus = 0.0;
        double sMin = 0.0;
        for (i = 0; i < datas.length; ++i) {
            for (j = 0; j < datas[i].size(); ++j) {
                x = datas[i].instance(j);
                for (k = j + 1; k < datas[i].size(); ++k) {
                    Instance y = datas[i].instance(k);
                    double distance = this.dm.measure(x, y);
                    if (!(maxIntraDist < distance)) continue;
                    maxIntraDist = distance;
                }
            }
        }
        for (i = 0; i < datas.length; ++i) {
            for (j = 0; j < datas[i].size(); ++j) {
                x = datas[i].instance(j);
                for (k = i + 1; k < datas.length; ++k) {
                    for (int l = 0; l < datas[k].size(); ++l) {
                        Instance y = datas[k].instance(l);
                        double distance = this.dm.measure(x, y);
                        if (distance < maxIntraDist) {
                            sMin += 1.0;
                        }
                        if (!(distance > maxIntraDist)) continue;
                        sPlus += 1.0;
                    }
                }
            }
        }
        double gamma = (sPlus - sMin) / (sPlus + sMin);
        return gamma;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 > score1;
    }
}

