/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.CosineSimilarity;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.tools.DatasetTools;

public class TraceScatterMatrix
implements ClusterEvaluation {
    private DistanceMeasure dm = new CosineSimilarity();

    @Override
    public double score(Dataset[] clusters) {
        Instance[] clusterCentroid = new Instance[clusters.length];
        int[] clusterSizes = new int[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            clusterCentroid[i] = DatasetTools.average(clusters[i]);
            clusterSizes[i] = clusters[i].size();
        }
        DefaultDataset data = new DefaultDataset();
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < clusters[i].size(); ++j) {
                data.add(clusters[i].instance(j));
            }
        }
        Instance overAllCentroid = DatasetTools.average(data);
        double sum = 0.0;
        for (int i = 0; i < clusters.length; ++i) {
            double cos = this.dm.measure(clusterCentroid[i], overAllCentroid);
            sum += cos * (double)clusterSizes[i];
        }
        return sum;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

