/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core;

import java.util.Iterator;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;

public abstract class AbstractInstance
implements Instance {
    private static final long serialVersionUID = -1712202124913999825L;
    static int nextID = 0;
    private final int ID = nextID++;
    private Object classValue;

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public Iterator<Double> iterator() {
        return new InstanceValueIterator();
    }

    protected AbstractInstance() {
        this(null);
    }

    protected AbstractInstance(Object classValue) {
        this.classValue = classValue;
    }

    @Override
    public Object classValue() {
        return this.classValue;
    }

    @Override
    public void setClassValue(Object classValue) {
        this.classValue = classValue;
    }

    @Override
    public Instance minus(Instance min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) - (Double)min.get(i));
        }
        return out;
    }

    @Override
    public Instance minus(double min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) - min);
        }
        return out;
    }

    @Override
    public Instance divide(double min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) / min);
        }
        return out;
    }

    @Override
    public Instance multiply(double value) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) * value);
        }
        return out;
    }

    @Override
    public int hashCode() {
        return this.ID;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInstance other = (AbstractInstance)obj;
        return this.ID == other.ID;
    }

    @Override
    public Instance multiply(Instance value) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) * (Double)value.get(i));
        }
        return out;
    }

    @Override
    public Instance divide(Instance min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) / (Double)min.get(i));
        }
        return out;
    }

    @Override
    public Instance add(double min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) + min);
        }
        return out;
    }

    @Override
    public Instance add(Instance min) {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, (Double)this.get(i) + (Double)min.get(i));
        }
        return out;
    }

    @Override
    public Instance sqrt() {
        DenseInstance out = new DenseInstance(new double[this.noAttributes()]);
        for (int i = 0; i < this.noAttributes(); ++i) {
            out.put(i, Math.sqrt((Double)this.get(i)));
        }
        return out;
    }

    class InstanceValueIterator
    implements Iterator<Double> {
        private int index = 0;

        InstanceValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractInstance.this.noAttributes();
        }

        @Override
        public Double next() {
            ++this.index;
            return AbstractInstance.this.value(this.index - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from instance using the iterator.");
        }
    }
}

