/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core;

public class Complex {
    public double im = 0.0;
    public double re = 0.0;
    public static final Complex I = new Complex(0.0, 1.0);

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public String toString() {
        return this.re + " + " + this.im + "i";
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public void plus(Complex b) {
        this.re += b.re;
        this.im += b.re;
    }

    public void minus(Complex b) {
        this.re -= b.re;
        this.im -= b.im;
    }

    public void times(Complex b) {
        double real = this.re * b.re - this.im * b.im;
        double imag = this.re * b.im + this.im * b.re;
        this.re = real;
        this.im = imag;
    }

    public void times(double alpha) {
        this.re *= alpha;
        this.im *= alpha;
    }

    public void conjugate() {
        this.im = -this.im;
    }

    public static Complex plus(Complex a, Complex b) {
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new Complex(real, imag);
    }

    public static Complex multiply(Complex a, double d) {
        return new Complex(a.re * d, a.im * d);
    }

    public static Complex multiply(Complex a, Complex b) {
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        return new Complex(real, imag);
    }
}

