/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import java.util.HashSet;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractDistance;

public class ConsistencyIndex
extends AbstractDistance {
    private static final long serialVersionUID = -9108138773263724130L;
    private double n;

    public ConsistencyIndex(int n) {
        this.n = n;
    }

    @Override
    public double measure(Instance a, Instance b) {
        int i;
        HashSet<Integer> set1 = new HashSet<Integer>();
        HashSet<Integer> set2 = new HashSet<Integer>();
        for (i = 0; i < a.noAttributes(); ++i) {
            set1.add((int)a.value(i));
        }
        for (i = 0; i < b.noAttributes(); ++i) {
            set2.add((int)b.value(i));
        }
        double k = Math.max(set1.size(), set2.size());
        if (k == 0.0 || k == this.n) {
            return 0.0;
        }
        set1.retainAll(set2);
        double r = set1.size();
        return (r * this.n - k * k) / (k * (this.n - k));
    }
}

