/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractCorrelation;

public class PearsonCorrelationCoefficient
extends AbstractCorrelation {
    private static final long serialVersionUID = -5805322724874919246L;

    @Override
    public double measure(Instance a, Instance b) {
        if (a.noAttributes() != b.noAttributes()) {
            throw new RuntimeException("Both instances should have the same length");
        }
        double xy = 0.0;
        double x = 0.0;
        double x2 = 0.0;
        double y = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < a.noAttributes(); ++i) {
            xy += a.value(i) * b.value(i);
            x += a.value(i);
            y += b.value(i);
            x2 += a.value(i) * a.value(i);
            y2 += b.value(i) * b.value(i);
        }
        int n = a.noAttributes();
        return (xy - x * y / (double)n) / Math.sqrt((x2 - x * x / (double)n) * (y2 - y * y / (double)n));
    }
}

