/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw.dtw;

import net.sf.javaml.distance.fastdtw.dtw.DTW;
import net.sf.javaml.distance.fastdtw.dtw.ExpandedResWindow;
import net.sf.javaml.distance.fastdtw.dtw.TimeWarpInfo;
import net.sf.javaml.distance.fastdtw.dtw.WarpPath;
import net.sf.javaml.distance.fastdtw.timeseries.PAA;
import net.sf.javaml.distance.fastdtw.timeseries.TimeSeries;

public class FastDTW {
    static final int DEFAULT_SEARCH_RADIUS = 1;

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ) {
        return FastDTW.fastDTW(tsI, tsJ, 1).getDistance();
    }

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius).getDistance();
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ) {
        return FastDTW.fastDTW(tsI, tsJ, 1).getPath();
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius);
    }

    private static TimeWarpInfo fastDTW(TimeSeries tsI, TimeSeries tsJ, int searchRadius) {
        if (searchRadius < 0) {
            searchRadius = 0;
        }
        int minTSsize = searchRadius + 2;
        if (tsI.size() <= minTSsize || tsJ.size() <= minTSsize) {
            return DTW.getWarpInfoBetween(tsI, tsJ);
        }
        double resolutionFactor = 2.0;
        PAA shrunkI = new PAA(tsI, (int)((double)tsI.size() / 2.0));
        PAA shrunkJ = new PAA(tsJ, (int)((double)tsJ.size() / 2.0));
        ExpandedResWindow window = new ExpandedResWindow(tsI, tsJ, shrunkI, shrunkJ, FastDTW.getWarpPathBetween(shrunkI, shrunkJ, searchRadius), searchRadius);
        return DTW.getWarpInfoBetween(tsI, tsJ, window);
    }
}

