/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.ranking;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.exception.TrainingRequiredException;
import net.sf.javaml.featureselection.FeatureRanking;
import net.sf.javaml.featureselection.FeatureScoring;
import net.sf.javaml.utils.ArrayUtils;

public class RankingFromScoring
implements FeatureRanking {
    private int[] ranking = null;
    private FeatureScoring ae;

    public RankingFromScoring(FeatureScoring ae) {
        this.ae = ae;
    }

    @Override
    public void build(Dataset data) {
        int noAttributes = data.noAttributes();
        this.ae.build(data);
        double[] values = new double[noAttributes];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.ae.score(i);
        }
        this.ranking = new int[values.length];
        int[] order = ArrayUtils.sort(values);
        for (int i = 0; i < order.length; ++i) {
            this.ranking[order[i]] = order.length - i - 1;
        }
    }

    @Override
    public int rank(int attIndex) {
        if (this.ranking == null) {
            throw new TrainingRequiredException();
        }
        return this.ranking[attIndex];
    }

    @Override
    public int noAttributes() {
        if (this.ranking == null) {
            throw new TrainingRequiredException();
        }
        return this.ranking.length;
    }
}

