/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.scoring;

import java.util.Random;
import java.util.Vector;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.ManhattanDistance;
import net.sf.javaml.featureselection.FeatureScoring;
import net.sf.javaml.filter.normalize.NormalizeMidrange;

public class RELIEF
implements FeatureScoring {
    private double[] weights = null;
    private int numNeighbors;
    private Random rg;
    private Vector<Instance> nearestHit;
    private Vector<Instance> nearestMiss;
    private ManhattanDistance dist = new ManhattanDistance();

    public RELIEF() {
        this(2, new Random(System.currentTimeMillis()));
    }

    public RELIEF(int numNeighbors, Random rg) {
        this.numNeighbors = numNeighbors;
        this.rg = rg;
    }

    public void setNumNeigbors(int num) {
        this.numNeighbors = num;
    }

    @Override
    public void build(Dataset data) {
        this.weights = new double[data.noAttributes()];
        NormalizeMidrange dnm = new NormalizeMidrange(0.5, 1.0);
        dnm.filter(data);
        int m = data.size();
        for (int i = 0; i < m; ++i) {
            Instance random = data.instance(this.rg.nextInt(data.size()));
            this.findNearest(data, random);
            for (int j = 0; j < this.weights.length; ++j) {
                this.weights[j] = this.weights[j] - this.diff(j, random, this.nearestHit) / (double)m + this.diff(j, random, this.nearestMiss) / (double)m;
            }
        }
    }

    private double diff(int index, Instance a, Vector<Instance> vector) {
        double sum = 0.0;
        for (Instance b : vector) {
            sum += Math.abs(a.value(index) - b.value(index));
        }
        return sum / (double)vector.size();
    }

    private void findNearest(Dataset data, Instance random) {
        this.nearestMiss = new Vector();
        this.nearestHit = new Vector();
        for (Instance i : data) {
            if (i.equals(random)) continue;
            if (i.classValue().equals(random.classValue())) {
                this.nearestHit.add(i);
                if (this.nearestHit.size() <= this.numNeighbors) continue;
                this.removeFarthest(this.nearestHit, random);
                continue;
            }
            this.nearestMiss.add(i);
            if (this.nearestMiss.size() <= this.numNeighbors) continue;
            this.removeFarthest(this.nearestMiss, random);
        }
    }

    private void removeFarthest(Vector<Instance> vector, Instance supplied) {
        Instance tmp = null;
        double max = 0.0;
        for (Instance inst : vector) {
            double tmpDist = this.dist.measure(inst, supplied);
            if (!(tmpDist > max)) continue;
            max = tmpDist;
            tmp = inst;
        }
        vector.remove(tmp);
    }

    @Override
    public double score(int attribute) {
        return this.weights[attribute];
    }

    @Override
    public int noAttributes() {
        return this.weights.length;
    }
}

