/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.subset;

import java.util.HashSet;
import java.util.Set;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.featureselection.FeatureSubsetSelection;
import net.sf.javaml.tools.DatasetTools;

public class GreedyForwardSelection
implements FeatureSubsetSelection {
    private int n;
    private DistanceMeasure dm;
    private Set<Integer> selectedAttributes = null;

    public GreedyForwardSelection(int n, DistanceMeasure dm) {
        this.n = n;
        this.dm = dm;
    }

    @Override
    public void build(Dataset data) {
        if (this.n > data.noAttributes()) {
            this.selectedAttributes = ((Instance)data.get(0)).keySet();
            return;
        }
        Instance classInstance = DatasetTools.createInstanceFromClass(data);
        this.selectedAttributes = new HashSet<Integer>();
        while (this.selectedAttributes.size() < this.n) {
            this.selectNext(data, classInstance);
        }
    }

    private void selectNext(Dataset data, Instance classInstance) {
        int bestIndex = -1;
        double bestScore = Double.NaN;
        for (int i = 0; i < data.noAttributes(); ++i) {
            if (this.selectedAttributes.contains(i)) continue;
            Instance attributeInstance = DatasetTools.createInstanceFromAttribute(data, i);
            double score = this.dm.measure(attributeInstance, classInstance);
            if (!Double.isNaN(score) && bestIndex == -1) {
                bestIndex = i;
                bestScore = score;
                continue;
            }
            if (Double.isNaN(score) || !this.dm.compare(score, bestScore)) continue;
            bestIndex = i;
            bestScore = score;
        }
        this.selectedAttributes.add(bestIndex);
    }

    @Override
    public Set<Integer> selectedAttributes() {
        return this.selectedAttributes;
    }

    @Override
    public int noAttributes() {
        return this.selectedAttributes.size();
    }
}

