/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.normalize;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.filter.AbstractFilter;

public class InstanceNormalizeMidrange
extends AbstractFilter {
    private static final double EPSILON = 1.0E-6;
    private double normalMiddle;
    private double normalRange;

    public InstanceNormalizeMidrange() {
        this(0.0, 2.0);
    }

    public InstanceNormalizeMidrange(double middle, double range) {
        this.normalMiddle = middle;
        this.normalRange = range;
    }

    @Override
    public void filter(Dataset data) {
        for (Instance i : data) {
            this.filter(i);
        }
    }

    @Override
    public void filter(Instance instance) {
        double min;
        double max = min = instance.value(0);
        for (Double d : instance) {
            if (d > max) {
                max = d;
            }
            if (!(d < min)) continue;
            min = d;
        }
        double midrange = (max + min) / 2.0;
        double range = max - min;
        for (int i = 0; i < instance.noAttributes(); ++i) {
            if (range < 1.0E-6) {
                instance.put(i, this.normalMiddle);
                continue;
            }
            instance.put(i, (instance.value(i) - midrange) / (range / this.normalRange) + this.normalMiddle);
        }
    }

    @Override
    public void build(Dataset data) {
    }
}

