/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.normalize;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.tools.DatasetTools;

public class NormalizeMean
extends AbstractFilter {
    private Instance mean = null;
    private Instance std = null;

    @Override
    public void filter(Dataset data) {
        if (data.size() == 0) {
            return;
        }
        this.mean = DatasetTools.average(data);
        this.std = DatasetTools.standardDeviation(data, this.mean);
        for (Instance i : data) {
            this.filter(i);
        }
    }

    @Override
    public void filter(Instance instance) {
        if (this.mean == null || this.std == null) {
            throw new RuntimeException("You should first call filterDataset for this filter, some parameters are not yet set.");
        }
        Instance tmp = instance.minus(this.mean).divide(this.std);
        for (int i = 0; i < instance.noAttributes(); ++i) {
            instance.put(i, tmp.value(i));
        }
    }
}

