/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.matrix;

import java.io.IOException;
import net.sf.javaml.matrix.MemoryMatrix;
import net.sf.javaml.matrix.SwapFileMatrix;

public abstract class Matrix {
    public static Matrix create(int cols, int rows) {
        try {
            return new MemoryMatrix(cols, rows);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                return new SwapFileMatrix(cols, rows);
            }
            catch (IOException e1) {
                return null;
            }
        }
    }

    public abstract void put(int var1, int var2, double var3);

    public abstract double get(int var1, int var2);

    public abstract int rows();

    public abstract int columns();
}

