/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools;

import java.util.Random;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;

public class InstanceTools {
    private static Random rg = new Random(System.currentTimeMillis());

    public static double[] array(Instance inst) {
        double[] out = new double[inst.noAttributes()];
        for (int i = 0; i < inst.noAttributes(); ++i) {
            out[i] = inst.value(i);
        }
        return out;
    }

    public static Instance randomInstance(int length) {
        double[] values = new double[length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = rg.nextDouble();
        }
        return new DenseInstance(values);
    }

    public static Instance randomGaussianInstance(int length) {
        double[] values = new double[length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = rg.nextGaussian();
        }
        return new DenseInstance(values);
    }

    public static boolean hasMissingValues(Instance inst) {
        for (int i = 0; i < inst.noAttributes(); ++i) {
            if (!Double.isNaN(inst.value(i))) continue;
            return true;
        }
        return false;
    }
}

