/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools.data;

import be.abeel.io.LineIterator;
import java.io.File;
import java.io.FileNotFoundException;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;

public class ARFFHandler {
    public static Dataset loadARFF(File file) throws FileNotFoundException {
        return ARFFHandler.loadARFF(file, -1);
    }

    public static Dataset loadARFF(File file, int classIndex) throws FileNotFoundException {
        LineIterator it = new LineIterator(file);
        it.setSkipBlanks(true);
        it.setCommentIdentifier("%");
        it.setSkipComments(true);
        DefaultDataset out = new DefaultDataset();
        boolean dataMode = false;
        for (String line : it) {
            if (dataMode) {
                String[] arr = line.split(",");
                double[] values = classIndex == -1 ? new double[arr.length] : new double[arr.length - 1];
                String classValue = null;
                for (int i = 0; i < arr.length; ++i) {
                    double val;
                    if (i == classIndex) {
                        classValue = arr[i];
                        continue;
                    }
                    try {
                        val = Double.parseDouble(arr[i]);
                    }
                    catch (NumberFormatException e) {
                        val = Double.NaN;
                    }
                    if (classIndex != -1 && i > classIndex) {
                        values[i - 1] = val;
                        continue;
                    }
                    values[i] = val;
                }
                out.add(new DenseInstance(values, classValue));
            }
            if (!line.equalsIgnoreCase("@data")) continue;
            dataMode = true;
        }
        return out;
    }
}

