/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.clustering.KMeans;
import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class IterativeMultiKMeans
implements Clusterer {
    private int kMin;
    private int kMax;
    private int repeats;
    private int clusters;
    private int iterations;
    private ClusterEvaluation ce;
    private DistanceMeasure dm;

    public IterativeMultiKMeans(ClusterEvaluation ce) {
        this(2, 6, 100, 10, new EuclideanDistance(), ce);
    }

    public IterativeMultiKMeans(int kMin, int kMax, ClusterEvaluation ce) {
        this(kMin, kMax, 100, 10, new EuclideanDistance(), ce);
    }

    public IterativeMultiKMeans(int kMin, int kMax, int iterations, int repeats, DistanceMeasure dm, ClusterEvaluation ce) {
        this.kMax = kMax;
        this.kMin = kMin;
        this.iterations = iterations;
        this.repeats = repeats;
        this.dm = dm;
        this.ce = ce;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        KMeans km = new KMeans(this.kMin, this.iterations, this.dm);
        Dataset[] bestClusters = km.cluster(data);
        this.clusters = this.kMin + 1;
        while (this.clusters <= this.kMax) {
            double bestScore = this.ce.score(bestClusters);
            for (int i = 0; i < this.repeats; ++i) {
                KMeans km2 = new KMeans(this.clusters, this.iterations, this.dm);
                Dataset[] tmpClusters = km2.cluster(data);
                double tmpScore = this.ce.score(tmpClusters);
                if (!this.ce.compareScore(bestScore, tmpScore)) continue;
                bestScore = tmpScore;
                bestClusters = tmpClusters;
            }
            ++this.clusters;
        }
        return bestClusters;
    }
}

