/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class Tau
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public Tau(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        double[] maxIntraDist = new double[datas.length];
        double sPlus = 0.0;
        double sMin = 0.0;
        double fw = 0.0;
        double fb = 0.0;
        double t = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            maxIntraDist[i] = Double.MIN_VALUE;
            for (int j = 0; j < datas[i].size(); ++j) {
                int k;
                Instance x = datas[i].instance(j);
                for (k = j + 1; k < datas[i].size(); ++k) {
                    Instance y = datas[i].instance(k);
                    double distance = this.dm.measure(x, y);
                    fw += 1.0;
                    if (maxIntraDist[i] < distance) {
                        maxIntraDist[i] = distance;
                    }
                    t += 1.0;
                }
                for (k = i + 1; k < datas.length; ++k) {
                    for (int l = 0; l < datas[k].size(); ++l) {
                        Instance y = datas[k].instance(l);
                        double distance = this.dm.measure(x, y);
                        fb += 1.0;
                        if (distance < maxIntraDist[i]) {
                            sMin += 1.0;
                        }
                        t += 1.0;
                        if (distance > maxIntraDist[i]) {
                            sPlus += 1.0;
                        }
                        t += 1.0;
                    }
                }
            }
        }
        double nd = fw + fb;
        double tau = (sPlus - sMin) / Math.sqrt((nd * (nd - 1.0) / 2.0 - t) * (nd * (nd - 1.0) / 2.0));
        return tau;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 > score1;
    }
}

