/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.utils;

import java.util.Random;

public class ArrayUtils {
    public static void scalarMultiply(double s, double[] array) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = s * array[i];
            }
        }
    }

    public static double[] add(double[] a, double[] b) {
        double[] out = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = a[i] + b[i];
        }
        return out;
    }

    public static double norm(double[] array) {
        if (array != null) {
            int n = array.length;
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += array[i] * array[i];
            }
            return Math.pow(sum, 0.5);
        }
        return 0.0;
    }

    public static void changeLength(double len, double[] array) {
        double factor = ArrayUtils.norm(array);
        factor = len / factor;
        ArrayUtils.scalarMultiply(factor, array);
    }

    public static int[] sort(double[] array) {
        int[] index = new int[array.length];
        array = (double[])array.clone();
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
            if (!Double.isNaN(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
        ArrayUtils.quickSort(array, index, 0, array.length - 1);
        return index;
    }

    private static void quickSort(double[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = ArrayUtils.partition(array, index, left, right);
            ArrayUtils.quickSort(array, index, left, middle);
            ArrayUtils.quickSort(array, index, middle + 1, right);
        }
    }

    private static int partition(double[] array, int[] index, int l, int r) {
        double pivot = array[index[(l + r) / 2]];
        while (l < r) {
            while (array[index[l]] < pivot && l < r) {
                ++l;
            }
            while (array[index[r]] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    public static void fillRandom(double[] array, Random rg) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = rg.nextDouble();
        }
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        return sum;
    }

    public static double[] substract(double[] a, double[] b) {
        double[] out = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = a[i] - b[i];
        }
        return out;
    }

    public static double max(double[] array) {
        double max = array[0];
        for (double d : array) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static void normalize(double[] doubles) {
        ArrayUtils.normalize(doubles, ArrayUtils.sum(doubles));
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            return;
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static int maxIndex(double[] array) {
        int maxIndex = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > array[maxIndex])) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static double min(double[] array) {
        double min = array[0];
        for (double d : array) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static void add(double[] array, double value) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + value;
        }
    }

    public static void abs(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.abs(array[i]);
        }
    }

    public static double[] multiply(double[] a, double[] b) {
        double[] out = (double[])a.clone();
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] * b[i];
        }
        return out;
    }

    public static double[] sum(double[] a, double[] b) {
        double[] out = (double[])a.clone();
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] + b[i];
        }
        return out;
    }

    public static double[] divide(double[] a, double[] b) {
        double[] out = (double[])a.clone();
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] / b[i];
        }
        return out;
    }

    public static void flipSign(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = -values[i];
        }
    }

    public static void reverse(int[] ranking) {
        for (int i = 0; i < ranking.length / 2; ++i) {
            int tmp = ranking[i];
            ranking[i] = ranking[ranking.length - 1 - i];
            ranking[ranking.length - 1 - i] = tmp;
        }
    }

    public static void reverse(double[] ranking) {
        for (int i = 0; i < ranking.length / 2; ++i) {
            double tmp = ranking[i];
            ranking[i] = ranking[ranking.length - 1 - i];
            ranking[ranking.length - 1 - i] = tmp;
        }
    }
}

