/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.utils;

import net.sf.javaml.utils.Polynomial;

public class GammaFunction {
    private static final double SQTPI = 2.5066282746310007;

    public static double stirlingFormula(double x) throws ArithmeticException {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Polynomial.polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    public static double gamma(double x) throws ArithmeticException {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * GammaFunction.stirlingFormula(q));
                return -z;
            }
            return GammaFunction.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Polynomial.polevl(x -= 2.0, P, 6);
        q = Polynomial.polevl(x, Q, 7);
        return z * p / q;
    }

    public static double logGamma(double x) throws ArithmeticException {
        double LOGPI = 1.1447298858494002;
        double[] A = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = GammaFunction.logGamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            z = LOGPI - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Polynomial.polevl(x, B, 5) / Polynomial.p1evl(x, C, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Polynomial.polevl(p, A, 4) / x);
        return q;
    }
}

