/*
 * Decompiled with CFR 0.152.
 */
package jal.SHORT;

import jal.SHORT.BinaryPredicate;
import jal.SHORT.Modification;
import jal.SHORT.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(short[] sArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(sArray, n, n2);
        }
        Sorting.insertion_sort(sArray, n, n2);
    }

    public static void sort(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(sArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(sArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(short[] sArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            short s = sArray[n3];
            int n4 = n3;
            short s2 = sArray[n4 - 1];
            while (s < s2) {
                sArray[n4] = s2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                s2 = sArray[--n4 - 1];
            }
            sArray[n4] = s;
        }
    }

    public static void insertion_sort(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            short s = sArray[n3];
            int n4 = n3;
            short s2 = sArray[n4 - 1];
            while (binaryPredicate.apply(s, s2)) {
                sArray[n4] = s2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                s2 = sArray[--n4 - 1];
            }
            sArray[n4] = s;
        }
    }

    private static int quickPartition(short[] sArray, int n, int n2) {
        short s = sArray[n];
        short s2 = sArray[n2 - 1];
        short s3 = sArray[n + (n2 - n) / 2];
        if (s3 < s) {
            if (s < s2) {
                s3 = s;
            } else if (s3 < s2) {
                s3 = s2;
            }
        } else if (s2 < s) {
            s3 = s;
        } else if (s2 < s3) {
            s3 = s2;
        }
        --n;
        while (true) {
            if (sArray[++n] < s3) {
                continue;
            }
            while (s3 < sArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            short s4 = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s4;
        }
    }

    private static int quickPartition(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        short s = sArray[n];
        short s2 = sArray[n2 - 1];
        short s3 = sArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(s3, s)) {
            if (binaryPredicate.apply(s, s2)) {
                s3 = s;
            } else if (binaryPredicate.apply(s3, s2)) {
                s3 = s2;
            }
        } else if (binaryPredicate.apply(s2, s)) {
            s3 = s;
        } else if (binaryPredicate.apply(s2, s3)) {
            s3 = s2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(sArray[++n], s3)) {
                continue;
            }
            while (binaryPredicate.apply(s3, sArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            short s4 = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s4;
        }
    }

    private static void qsortLoop(short[] sArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(sArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(sArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(short[] sArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(sArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(sArray, n, n3);
            Sorting.stable_sort(sArray, n3, n2);
            Sorting.inplace_merge(sArray, n, n3, n2);
        }
    }

    public static void stable_sort(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(sArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(sArray, n, n3, binaryPredicate);
            Sorting.stable_sort(sArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(sArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(short[] sArray, int n, int n2, int n3) {
        Sorting.make_heap(sArray, n, n2);
        int n4 = n2;
        while (n4 < n3) {
            if (sArray[n4] < sArray[n]) {
                short s = sArray[n4];
                sArray[n4] = sArray[n];
                sArray[n] = s;
                Sorting.adjust_heap(sArray, n, n, n2);
            }
            ++n4;
        }
        Sorting.sort_heap(sArray, n, n2);
    }

    public static void partial_sort(short[] sArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(sArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(sArray[n4], sArray[n])) {
                short s = sArray[n4];
                sArray[n4] = sArray[n];
                sArray[n] = s;
                Sorting.adjust_heap(sArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(sArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(sArray, sArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(sArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (sArray[n] < sArray2[n3]) {
                sArray2[n3] = sArray[n];
                Sorting.adjust_heap(sArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(sArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(sArray, sArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(sArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                sArray2[n3] = sArray[n];
                Sorting.adjust_heap(sArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(sArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(short[] sArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(sArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(sArray, n, n3);
    }

    public static void nth_element(short[] sArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(sArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(sArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(short[] sArray, int n, int n2, short s) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (sArray[n5] < s) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(short[] sArray, int n, int n2, short s, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(sArray[n5], s)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(short[] sArray, int n, int n2, short s) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (s < sArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(short[] sArray, int n, int n2, short s, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(s, sArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(short[] sArray, int n, int n2, short s) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (sArray[n5] < s) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (s < sArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(sArray, n, n5, s);
            int n7 = Sorting.upper_bound(sArray, n5 + 1, n + n3, s);
            return new Range(sArray, n6, n7);
        }
        return new Range(sArray, n, n);
    }

    public static Range equal_range(short[] sArray, int n, int n2, short s, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(sArray[n5], s)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(s, sArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(sArray, n, n5, s, binaryPredicate);
            int n7 = Sorting.upper_bound(sArray, n5 + 1, n + n3, s, binaryPredicate);
            return new Range(sArray, n6, n7);
        }
        return new Range(sArray, n, n);
    }

    public static boolean binary_search(short[] sArray, int n, int n2, short s) {
        int n3 = Sorting.lower_bound(sArray, n, n2, s);
        return n3 < n2 && s >= sArray[n3];
    }

    public static boolean binary_search(short[] sArray, int n, int n2, short s, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(sArray, n, n2, s, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(s, sArray[n3]);
    }

    public static int merge(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            sArray3[n5++] = sArray2[n3] < sArray[n] ? sArray2[n3++] : sArray[n++];
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            sArray3[n5++] = binaryPredicate.apply(sArray2[n3], sArray[n]) ? sArray2[n3++] : sArray[n++];
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(short[] sArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (sArray[n2] < sArray[n]) {
                short s = sArray[n];
                sArray[n] = sArray[n2];
                sArray[n2] = s;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(sArray, n2, n3, sArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(sArray, n, n2, sArray[n4]);
        }
        Modification.rotate(sArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(sArray, n, n5, n2);
        Sorting.inplace_merge(sArray, n2, n4, n3);
    }

    public static void inplace_merge(short[] sArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(sArray[n2], sArray[n])) {
                short s = sArray[n];
                sArray[n] = sArray[n2];
                sArray[n2] = s;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(sArray, n2, n3, sArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(sArray, n, n2, sArray[n4], binaryPredicate);
        }
        Modification.rotate(sArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(sArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(sArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (sArray2[n3] < sArray[n]) {
                return false;
            }
            if (sArray[n] < sArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (sArray[n] < sArray2[n3]) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (sArray2[n3] < sArray[n]) {
                sArray3[n5++] = sArray2[n3++];
                continue;
            }
            sArray3[n5++] = sArray[n++];
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) {
                sArray3[n5++] = sArray2[n3++];
                continue;
            }
            sArray3[n5++] = sArray[n++];
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (sArray[n] < sArray2[n3]) {
                ++n;
                continue;
            }
            if (sArray2[n3] < sArray[n]) {
                ++n3;
                continue;
            }
            sArray3[n5++] = sArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) {
                ++n3;
                continue;
            }
            sArray3[n5++] = sArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (sArray[n] < sArray2[n3]) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (sArray2[n3] < sArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (sArray[n] < sArray2[n3]) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (sArray2[n3] < sArray[n]) {
                sArray3[n5++] = sArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                sArray3[n5++] = sArray[n++];
                continue;
            }
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) {
                sArray3[n5++] = sArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(sArray, sArray3, n, n2, n5);
        Modification.copy(sArray2, sArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(short[] sArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        short s = sArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && sArray[n3] < s) {
            sArray[n2] = sArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        sArray[n2] = s;
    }

    public static void push_heap(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        short s = sArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(sArray[n3], s)) {
            sArray[n2] = sArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        sArray[n2] = s;
    }

    private static void adjust_heap(short[] sArray, int n, int n2, int n3) {
        short s = sArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (sArray[n + n6] < sArray[n + (n6 - 1)]) {
                --n6;
            }
            sArray[n + n5] = sArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            sArray[n + n5] = sArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && sArray[n + n7] < s) {
            sArray[n + n5] = sArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        sArray[n + n5] = s;
    }

    private static void adjust_heap(short[] sArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        short s = sArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(sArray[n + n6], sArray[n + (n6 - 1)])) {
                --n6;
            }
            sArray[n + n5] = sArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            sArray[n + n5] = sArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(sArray[n + n7], s)) {
            sArray[n + n5] = sArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        sArray[n + n5] = s;
    }

    public static void pop_heap(short[] sArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        short s = sArray[--n2];
        sArray[n2] = sArray[n];
        sArray[n] = s;
        Sorting.adjust_heap(sArray, n, n, n2);
    }

    public static void pop_heap(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        short s = sArray[--n2];
        sArray[n2] = sArray[n];
        sArray[n] = s;
        Sorting.adjust_heap(sArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(short[] sArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(sArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(sArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(short[] sArray, int n, int n2) {
        while (n2 - n > 1) {
            short s = sArray[--n2];
            sArray[n2] = sArray[n];
            sArray[n] = s;
            Sorting.adjust_heap(sArray, n, n, n2);
        }
    }

    public static void sort_heap(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            short s = sArray[--n2];
            sArray[n2] = sArray[n];
            sArray[n] = s;
            Sorting.adjust_heap(sArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(short[] sArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (sArray[n3] >= sArray[n]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(sArray[n3], sArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(short[] sArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (sArray[n] >= sArray[n3]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(sArray[n], sArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (sArray[n] < sArray2[n3]) {
                return true;
            }
            if (sArray2[n3++] >= sArray[n++]) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(sArray[n], sArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(sArray2[n3++], sArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(short[] sArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (sArray[--n3] >= sArray[n4]) continue;
            int n5 = n2;
            while (sArray[n3] >= sArray[--n5]) {
            }
            short s = sArray[n3];
            sArray[n3] = sArray[n5];
            sArray[n5] = s;
            Modification.reverse(sArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(sArray, n, n2);
        return false;
    }

    public static boolean next_permutation(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(sArray[--n3], sArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(sArray[n3], sArray[--n5])) {
            }
            short s = sArray[n3];
            sArray[n3] = sArray[n5];
            sArray[n5] = s;
            Modification.reverse(sArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(sArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(short[] sArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (sArray[n4] >= sArray[--n3]) continue;
            int n5 = n2;
            while (sArray[--n5] >= sArray[n3]) {
            }
            short s = sArray[n3];
            sArray[n3] = sArray[n5];
            sArray[n5] = s;
            Modification.reverse(sArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(sArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(sArray[n4], sArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(sArray[--n5], sArray[n3])) {
            }
            short s = sArray[n3];
            sArray[n3] = sArray[n5];
            sArray[n5] = s;
            Modification.reverse(sArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(sArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

