/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class AlbersProjection
extends Projection {
    private static final double EPS10 = 1.0E-10;
    private static final double TOL7 = 1.0E-7;
    private double ec;
    private double n;
    private double c;
    private double dd;
    private double n2;
    private double rho0;
    private double phi1;
    private double phi2;
    private double[] en;
    private static final int N_ITER = 15;
    private static final double EPSILON = 1.0E-7;
    private static final double TOL = 1.0E-10;

    public AlbersProjection() {
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLatitude1 = MapMath.degToRad(45.5);
        this.projectionLatitude2 = MapMath.degToRad(29.5);
        this.initialize();
    }

    private static double phi1_(double qs, double Te, double Tone_es) {
        double dphi;
        double Phi = Math.asin(0.5 * qs);
        if (Te < 1.0E-7) {
            return Phi;
        }
        int i = 15;
        do {
            double sinpi = Math.sin(Phi);
            double cospi = Math.cos(Phi);
            double con = Te * sinpi;
            double com = 1.0 - con * con;
            dphi = 0.5 * com * com / cospi * (qs / Tone_es - sinpi / com + 0.5 / Te * Math.log((1.0 - con) / (1.0 + con)));
            Phi += dphi;
        } while (Math.abs(dphi) > 1.0E-10 && --i != 0);
        return i != 0 ? Phi : Double.MAX_VALUE;
    }

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double d;
        double rho = this.c - (!this.spherical ? this.n * MapMath.qsfn(Math.sin(lpphi), this.e, this.one_es) : this.n2 * Math.sin(lpphi));
        if (d < 0.0) {
            throw new ProjectionException("F");
        }
        rho = this.dd * Math.sqrt(rho);
        out.x = rho * Math.sin(lplam *= this.n);
        out.y = this.rho0 - rho * Math.cos(lplam);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double rho = MapMath.distance(xyx, xyy = this.rho0 - xyy);
        if (rho != 0.0) {
            double lplam;
            if (this.n < 0.0) {
                rho = -rho;
                xyx = -xyx;
                xyy = -xyy;
            }
            double lpphi = rho / this.dd;
            if (!this.spherical) {
                if (Math.abs(this.ec - Math.abs(lpphi = (this.c - lpphi * lpphi) / this.n)) > 1.0E-7) {
                    if ((lpphi = AlbersProjection.phi1_(lpphi, this.e, this.one_es)) == Double.MAX_VALUE) {
                        throw new ProjectionException("I");
                    }
                } else {
                    lpphi = lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                }
            } else {
                double d;
                lpphi = (this.c - lpphi * lpphi) / this.n2;
                lpphi = Math.abs(d) <= 1.0 ? Math.asin(lpphi) : (lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
            }
            out.x = lplam = Math.atan2(xyx, xyy) / this.n;
            out.y = lpphi;
        } else {
            out.x = 0.0;
            out.y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return out;
    }

    public void initialize() {
        double sinphi;
        super.initialize();
        this.phi1 = this.projectionLatitude1;
        this.phi2 = this.projectionLatitude2;
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-10) {
            throw new IllegalArgumentException("-21");
        }
        this.n = sinphi = Math.sin(this.phi1);
        double cosphi = Math.cos(this.phi1);
        boolean secant = Math.abs(this.phi1 - this.phi2) >= 1.0E-10;
        boolean bl = this.spherical = this.es <= 0.0;
        if (!this.spherical) {
            this.en = MapMath.enfn(this.es);
            if (this.en == null) {
                throw new IllegalArgumentException("0");
            }
            double m1 = MapMath.msfn(sinphi, cosphi, this.es);
            double ml1 = MapMath.qsfn(sinphi, this.e, this.one_es);
            if (secant) {
                sinphi = Math.sin(this.phi2);
                cosphi = Math.cos(this.phi2);
                double m2 = MapMath.msfn(sinphi, cosphi, this.es);
                double ml2 = MapMath.qsfn(sinphi, this.e, this.one_es);
                this.n = (m1 * m1 - m2 * m2) / (ml2 - ml1);
            }
            this.ec = 1.0 - 0.5 * this.one_es * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
            this.c = m1 * m1 + this.n * ml1;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n * MapMath.qsfn(Math.sin(this.projectionLatitude), this.e, this.one_es));
        } else {
            if (secant) {
                this.n = 0.5 * (this.n + Math.sin(this.phi2));
            }
            this.n2 = this.n + this.n;
            this.c = cosphi * cosphi + this.n2 * sinphi;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n2 * Math.sin(this.projectionLatitude));
        }
    }

    public boolean isEqualArea() {
        return true;
    }

    public boolean hasInverse() {
        return true;
    }

    public int getEPSGCode() {
        return 9822;
    }

    public String toString() {
        return "Albers Equal Area";
    }
}

