/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

public class EPSGraphics2D
extends VectorGraphics2D {
    protected static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> a = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> b = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});

    public EPSGraphics2D(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.writeHeader();
    }

    protected void writeString(String string, double d, double d2) {
        string = string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        this.write("gsave 1 -1 scale ");
        string = string.replaceAll("[\r\n]", "");
        this.write(d, " -", d2, " M (", string, ") show ");
        this.writeln("grestore");
    }

    public void setStroke(Stroke stroke) {
        BasicStroke basicStroke = this.getStroke() instanceof BasicStroke ? (BasicStroke)this.getStroke() : new BasicStroke();
        super.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            if (((BasicStroke)(stroke = (BasicStroke)stroke)).getLineWidth() != basicStroke.getLineWidth()) {
                this.writeln(Float.valueOf(((BasicStroke)stroke).getLineWidth()), " setlinewidth");
            }
            if (((BasicStroke)stroke).getLineJoin() != basicStroke.getLineJoin()) {
                this.writeln(b.get(((BasicStroke)stroke).getLineJoin()), " setlinejoin");
            }
            if (((BasicStroke)stroke).getEndCap() != basicStroke.getEndCap()) {
                this.writeln(a.get(((BasicStroke)stroke).getEndCap()), " setlinecap");
            }
            if (!Arrays.equals(((BasicStroke)stroke).getDashArray(), basicStroke.getDashArray()) || ((BasicStroke)stroke).getDashPhase() != basicStroke.getDashPhase()) {
                this.writeln("[", DataUtils.join(" ", ((BasicStroke)stroke).getDashArray()), "] ", Float.valueOf(((BasicStroke)stroke).getDashPhase()), " setdash");
            }
        }
    }

    protected void writeImage(Image image, int n, int n2, double d, double d2, double d3, double d4) {
        image = GraphicsUtils.toBufferedImage(image);
        Object object = image;
        int n3 = ((BufferedImage)image).getWidth();
        int n4 = ((BufferedImage)object).getHeight();
        int n5 = ((BufferedImage)object).getSampleModel().getNumBands();
        StringBuffer stringBuffer = new StringBuffer(n3 * n4 * n5 << 1);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = ((BufferedImage)object).getRGB(j, i) & 0xFFFFFF;
                if (n5 >= 3) {
                    String string = String.format("%06x", n6);
                    stringBuffer.append(string);
                    continue;
                }
                if (n5 != 1) continue;
                stringBuffer.append(String.format("%02x", n6));
            }
            stringBuffer.append("\n");
        }
        object = stringBuffer.toString();
        n3 = ((BufferedImage)image).getSampleModel().getNumBands();
        int n7 = (int)(Math.ceil((double)DataUtils.max(((BufferedImage)image).getSampleModel().getSampleSize()) / 8.0) * 8.0);
        if (n3 > 3) {
            n3 = 3;
        }
        this.writeln("gsave");
        this.writeln(d, " ", d2, " ", d3, " ", d4, " ", n, " ", n2, " ", n7, " img false ", n3, " colorimage");
        this.writeln(object, ">");
        this.writeln("grestore");
    }

    public void setColor(Color color) {
        Color color2 = this.getColor();
        if (color != null) {
            super.setColor(color);
            if (color2.getRed() != color.getRed() || color2.getGreen() != color.getGreen() || color2.getBlue() != color.getBlue()) {
                double d = (double)color.getRed() / 255.0;
                double d2 = (double)color.getGreen() / 255.0;
                double d3 = (double)color.getBlue() / 255.0;
                this.writeln(d, " ", d2, " ", d3, " rgb");
            }
        }
    }

    public void setFont(Font font) {
        if (!this.getFont().equals(font)) {
            super.setFont(font);
            this.writeln("/", font.getPSName(), " ", Float.valueOf(font.getSize2D()), " selectfont");
        }
    }

    public void setClip(Shape shape) {
        if (this.getClip() != null) {
            this.writeln("cliprestore");
        }
        super.setClip(shape);
        if (this.getClip() != null) {
            this.writeShape(this.getClip());
            this.writeln(" clip");
        }
    }

    public void setTransform(AffineTransform object) {
        if (this.getTransform().equals(object)) {
            return;
        }
        super.setTransform((AffineTransform)object);
        object = new double[6];
        this.getTransform().getMatrix((double[])object);
        this.writeln("basematrix setmatrix [", DataUtils.join(" ", (double[])object), "] concat");
    }

    public void translate(double d, double d2) {
        super.translate(d, d2);
        if (d != 0.0 || d2 != 0.0) {
            this.writeln(d, " ", d2, " translate");
        }
    }

    public void scale(double d, double d2) {
        super.scale(d, d2);
        if (d != 1.0 || d2 != 1.0) {
            this.writeln(d, " ", d2, " scale");
        }
    }

    public void rotate(double d) {
        super.rotate(d);
        if (d != 0.0) {
            this.writeln(d / Math.PI * 180.0, " rotate");
        }
    }

    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        if (d != 0.0) {
            this.writeln(d2, " ", d3, " translate ", d / Math.PI * 180.0, " rotate ", -d2, " ", -d3, " translate");
        }
    }

    public void shear(double d, double d2) {
        super.shear(d, d2);
        if (d != 0.0 || d2 != 0.0) {
            this.setTransform(this.getTransform());
        }
    }

    protected void writeHeader() {
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangle2D.getX() * 2.834645669291339;
        double d2 = rectangle2D.getY() * 2.834645669291339;
        double d3 = rectangle2D.getWidth() * 2.834645669291339;
        double d4 = rectangle2D.getHeight() * 2.834645669291339;
        this.writeln("%!PS-Adobe-3.0 EPSF-3.0");
        this.writeln("%%BoundingBox: ", (int)Math.floor(d), " ", (int)Math.floor(d2), " ", (int)Math.ceil(d + d3), " ", (int)Math.ceil(d2 + d4));
        this.writeln("%%HiResBoundingBox: ", d, " ", d2, " ", d + d3, " ", d2 + d4);
        this.writeln("%%LanguageLevel: 3");
        this.writeln("%%Pages: 1");
        this.writeln("%%Page: 1 1");
        this.writeln("/M /moveto load def");
        this.writeln("/L /lineto load def");
        this.writeln("/C /curveto load def");
        this.writeln("/Z /closepath load def");
        this.writeln("/RL /rlineto load def");
        this.writeln("/rgb /setrgbcolor load def");
        this.writeln("/rect { ", "/height exch def /width exch def /y exch def /x exch def ", "x y M width 0 RL 0 height RL width neg 0 RL ", "} bind def");
        this.writeln("/ellipse { ", "/endangle exch def /startangle exch def ", "/ry exch def /rx exch def /y exch def /x exch def ", "/savematrix matrix currentmatrix def ", "x y translate rx ry scale 0 0 1 startangle endangle arcn ", "savematrix setmatrix ", "} bind def");
        this.writeln("/img { ", "/bits exch def /imgheight exch def /imgwidth exch def ", "/height exch def /width exch def /y exch def /x exch def ", "x y translate width height scale ", "imgwidth imgheight bits [imgwidth 0 0 imgheight 0 0] currentfile ", "/ASCIIHexDecode filter ", "} bind def");
        this.writeln("/", this.getFont().getPSName(), " ", Float.valueOf(this.getFont().getSize2D()), " selectfont");
        this.writeln("gsave");
        this.writeln("clipsave");
        this.writeln("/DeviceRGB setcolorspace");
        this.writeln("0 ", d4, " translate");
        this.writeln(2.834645669291339, " -", 2.834645669291339, " scale");
        this.writeln("/basematrix matrix currentmatrix def");
    }

    protected void writeClosingDraw(Shape shape) {
        this.writeln(" stroke");
    }

    protected void writeClosingFill(Shape shape) {
        this.writeln(" fill");
        if (!(this.getPaint() instanceof Color)) {
            super.writeClosingFill(shape);
        }
    }

    protected void writeShape(Shape object) {
        this.write("newpath ");
        if (object instanceof Line2D) {
            object = (Line2D)object;
            double d = ((Line2D)object).getX1();
            double d2 = ((Line2D)object).getY1();
            double d3 = ((Line2D)object).getX2();
            double d4 = ((Line2D)object).getY2();
            this.write(d, " ", d2, " M ", d3, " ", d4, " L");
            return;
        }
        if (object instanceof Rectangle2D) {
            object = (Rectangle2D)object;
            double d = ((RectangularShape)object).getX();
            double d5 = ((RectangularShape)object).getY();
            double d6 = ((RectangularShape)object).getWidth();
            double d7 = ((RectangularShape)object).getHeight();
            this.write(d, " ", d5, " ", d6, " ", d7, " rect Z");
            return;
        }
        if (object instanceof Ellipse2D) {
            object = (Ellipse2D)object;
            double d = ((RectangularShape)object).getX() + ((RectangularShape)object).getWidth() / 2.0;
            double d8 = ((RectangularShape)object).getY() + ((RectangularShape)object).getHeight() / 2.0;
            double d9 = ((RectangularShape)object).getWidth() / 2.0;
            double d10 = ((RectangularShape)object).getHeight() / 2.0;
            this.write(d, " ", d8, " ", d9, " ", d10, " ", 360.0, " ", 0.0, " ellipse Z");
            return;
        }
        if (object instanceof Arc2D) {
            object = (Arc2D)object;
            double d = ((RectangularShape)object).getX() + ((RectangularShape)object).getWidth() / 2.0;
            double d11 = ((RectangularShape)object).getY() + ((RectangularShape)object).getHeight() / 2.0;
            double d12 = ((RectangularShape)object).getWidth() / 2.0;
            double d13 = ((RectangularShape)object).getHeight() / 2.0;
            double d14 = -((Arc2D)object).getAngleStart();
            double d15 = -(((Arc2D)object).getAngleStart() + ((Arc2D)object).getAngleExtent());
            this.write(d, " ", d11, " ", d12, " ", d13, " ", d14, " ", d15, " ellipse");
            if (((Arc2D)object).getArcType() == 1) {
                this.write(" Z");
                return;
            }
            if (((Arc2D)object).getArcType() == 2) {
                this.write(" ", d, " ", d11, " L Z");
            }
            return;
        }
        object = object.getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        int n = 0;
        while (!object.isDone()) {
            if (n > 0) {
                this.write(" ");
            }
            switch (object.currentSegment(dArray)) {
                case 0: {
                    this.write(dArray[0], " ", dArray[1], " M");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 1: {
                    this.write(dArray[0], " ", dArray[1], " L");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 3: {
                    this.write(dArray[0], " ", dArray[1], " ", dArray[2], " ", dArray[3], " ", dArray[4], " ", dArray[5], " C");
                    dArray2[0] = dArray[4];
                    dArray2[1] = dArray[5];
                    break;
                }
                case 2: {
                    double d = dArray2[0] + 0.6666666666666666 * (dArray[0] - dArray2[0]);
                    double d16 = dArray2[1] + 0.6666666666666666 * (dArray[1] - dArray2[1]);
                    double d17 = dArray[0] + 0.3333333333333333 * (dArray[2] - dArray[0]);
                    double d18 = dArray[1] + 0.3333333333333333 * (dArray[3] - dArray[1]);
                    double d19 = dArray[2];
                    double d20 = dArray[3];
                    this.write(d, " ", d16, " ", d17, " ", d18, " ", d19, " ", d20, " C");
                    dArray2[0] = d19;
                    dArray2[1] = d20;
                    break;
                }
                case 4: {
                    this.write("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            object.next();
        }
    }

    protected String getFooter() {
        return "grestore  % Restore state\n%%EOF\n";
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return super.getBytes();
        }
    }
}

