/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.security.AES;
import org.h2.security.BlockCipher;
import org.h2.security.SHA256;
import org.h2.security.XTEA;

public class CipherFactory {
    public static BlockCipher getBlockCipher(String algorithm) throws SQLException {
        if ("XTEA".equalsIgnoreCase(algorithm)) {
            return new XTEA();
        }
        if ("AES".equalsIgnoreCase(algorithm)) {
            return new AES();
        }
        throw Message.getSQLException(90055, algorithm);
    }

    public static SHA256 getHash(String algorithm) throws SQLException {
        if ("SHA256".equalsIgnoreCase(algorithm)) {
            return new SHA256();
        }
        throw Message.getInvalidValueException(algorithm, "algorithm");
    }
}

