/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.store.fs.FileObject;
import org.h2.util.IOUtils;

public class FileObjectZip
implements FileObject {
    private ZipFile file;
    private ZipEntry entry;
    private long pos;
    private InputStream in;
    private long inPos;
    private long length;

    public FileObjectZip(ZipFile file, ZipEntry entry) {
        this.file = file;
        this.entry = entry;
        this.length = entry.getSize();
    }

    public void close() throws IOException {
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public long length() throws IOException {
        return this.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int l;
        if (this.inPos > this.pos) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
        if (this.in == null) {
            this.in = this.file.getInputStream(this.entry);
            this.inPos = 0L;
        }
        if (this.inPos < this.pos) {
            IOUtils.skipFully(this.in, this.pos - this.inPos);
            this.inPos = this.pos;
        }
        if ((l = IOUtils.readFully(this.in, b, off, len)) != len) {
            throw new EOFException();
        }
        this.pos += (long)len;
        this.inPos += (long)len;
    }

    public void seek(long pos) throws IOException {
        this.pos = pos;
    }

    public void setLength(long newLength) throws IOException {
        throw new IOException("File is read-only");
    }

    public void sync() throws IOException {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        throw new IOException("File is read-only");
    }
}

