/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;

public class TableView
extends Table {
    private String querySQL;
    private ObjectArray tables;
    private final String[] columnNames;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private SQLException createException;
    private SmallLRUCache indexCache = new SmallLRUCache(64);
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;

    public TableView(Schema schema, int id, String name, String querySQL, ObjectArray params, String[] columnNames, Session session, boolean recursive) throws SQLException {
        super(schema, id, name, false);
        this.querySQL = querySQL;
        this.columnNames = columnNames;
        this.recursive = recursive;
        this.index = new ViewIndex(this, querySQL, params, recursive);
        this.initColumnsAndTables(session);
    }

    public Query recompileQuery(Session session) throws SQLException {
        Prepared p = session.prepare(this.querySQL);
        if (!(p instanceof Query)) {
            throw Message.getSyntaxError(this.querySQL, 0);
        }
        Query query = (Query)p;
        this.querySQL = query.getPlanSQL();
        return query;
    }

    private void initColumnsAndTables(Session session) throws SQLException {
        Object[] cols;
        block7: {
            this.removeViewFromTables();
            try {
                Query query = this.recompileQuery(session);
                this.tables = new ObjectArray(query.getTables());
                ObjectArray expressions = query.getExpressions();
                ObjectArray list = new ObjectArray();
                for (int i = 0; i < query.getColumnCount(); ++i) {
                    Expression expr = (Expression)expressions.get(i);
                    String name = null;
                    if (this.columnNames != null && this.columnNames.length > i) {
                        name = this.columnNames[i];
                    }
                    if (name == null) {
                        name = expr.getAlias();
                    }
                    int type = expr.getType();
                    long precision = expr.getPrecision();
                    int scale = expr.getScale();
                    int displaySize = expr.getDisplaySize();
                    Column col = new Column(name, type, precision, scale, displaySize);
                    col.setTable(this, i);
                    list.add(col);
                }
                cols = new Column[list.size()];
                list.toArray(cols);
                this.createException = null;
                if (this.getId() != 0) {
                    this.addViewToTables();
                }
                this.viewQuery = query;
            }
            catch (SQLException e) {
                this.createException = e;
                this.tables = new ObjectArray();
                cols = new Column[]{};
                if (!this.recursive || this.columnNames == null) break block7;
                cols = new Column[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    cols[i] = new Column(this.columnNames[i], 13);
                }
                this.index.setRecursive(true);
                this.recursive = true;
                this.createException = null;
            }
        }
        this.setColumns((Column[])cols);
    }

    public boolean getInvalid() {
        return this.createException != null;
    }

    public PlanItem getBestPlanItem(Session session, int[] masks) throws SQLException {
        PlanItem item = new PlanItem();
        item.cost = this.index.getCost(session, masks);
        IntArray masksArray = new IntArray(masks == null ? new int[]{} : masks);
        ViewIndex i2 = (ViewIndex)this.indexCache.get(masksArray);
        if (i2 == null || i2.getSession() != session) {
            i2 = new ViewIndex(this, this.index, session, masks);
            this.indexCache.put(masksArray, i2);
        }
        item.setIndex(i2);
        return item;
    }

    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE FORCE VIEW ");
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns.length > 0) {
            buff.append('(');
            for (int i = 0; i < this.columns.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.columns[i].getSQL());
            }
            buff.append(")");
        }
        buff.append(" AS\n");
        buff.append(this.querySQL);
        return buff.toString();
    }

    public void checkRename() throws SQLException {
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
    }

    public void close(Session session) throws SQLException {
    }

    public void unlock(Session s) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public void removeIndex(String indexName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, int headPos, String comment) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public long getRowCount(Session session) {
        throw Message.getInternalError();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public boolean canDrop() {
        return true;
    }

    public String getTableType() {
        return "VIEW";
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.querySQL = null;
        this.index = null;
        this.invalidate();
    }

    public String getSQL() {
        if (this.getTemporary()) {
            StringBuffer buff = new StringBuffer(this.querySQL.length());
            buff.append("(");
            buff.append(this.querySQL);
            buff.append(")");
            return buff.toString();
        }
        return super.getSQL();
    }

    public Index getScanIndex(Session session) throws SQLException {
        if (this.createException != null) {
            String msg = this.createException.getMessage();
            throw Message.getSQLException(90109, new String[]{this.getSQL(), msg}, this.createException);
        }
        PlanItem item = this.getBestPlanItem(session, null);
        return item.getIndex();
    }

    public ObjectArray getIndexes() {
        return null;
    }

    public ObjectArray getTables() {
        return this.tables;
    }

    public void recompile(Session session) throws SQLException {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table t = (Table)this.tables.get(i);
            t.removeView(this);
        }
        this.tables.clear();
        this.initColumnsAndTables(session);
    }

    public long getMaxDataModificationId() {
        if (this.createException != null) {
            throw Message.getInternalError();
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long dbMod = this.database.getModificationDataId();
        if (dbMod > this.lastModificationCheck && this.maxDataModificationId <= dbMod) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = dbMod;
        }
        return this.maxDataModificationId;
    }

    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (int i = 0; i < this.tables.size(); ++i) {
                Table t = (Table)this.tables.get(i);
                t.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table t = (Table)this.tables.get(i);
            t.addView(this);
        }
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session s, User owner, Query query) throws SQLException {
        String tempViewName = s.getNextTempViewName();
        Schema mainSchema = s.getDatabase().getSchema("PUBLIC");
        String querySQL = query.getPlanSQL();
        TableView v = new TableView(mainSchema, 0, tempViewName, querySQL, query.getParameters(), null, s, false);
        v.setOwner(owner);
        v.setTemporary(true);
        return v;
    }
}

