/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import org.h2.message.Message;

public class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final char[] chars = new char[4096];
    private final ByteArrayOutputStream out;
    private final Writer writer;
    private int pos;
    private int remaining;
    private byte[] buffer;

    public ReaderInputStream(Reader reader) throws SQLException {
        this.reader = reader;
        this.out = new ByteArrayOutputStream(4096);
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.out, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    private void fillBuffer() throws IOException {
        if (this.remaining == 0) {
            this.pos = 0;
            this.remaining = this.reader.read(this.chars, 0, 4096);
            if (this.remaining < 0) {
                return;
            }
            this.writer.write(this.chars, 0, this.remaining);
            this.writer.flush();
            this.buffer = this.out.toByteArray();
            this.remaining = this.buffer.length;
            this.out.reset();
        }
    }

    public int read() throws IOException {
        if (this.remaining == 0) {
            this.fillBuffer();
        }
        if (this.remaining < 0) {
            return -1;
        }
        --this.remaining;
        return this.buffer[this.pos++] & 0xFF;
    }
}

