/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private long start = 1L;
    private long increment = 1L;
    private long cacheSize = 32L;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90035, this.sequenceName);
        }
        int id = this.getObjectId(false, true);
        Sequence sequence = new Sequence(this.getSchema(), id, this.sequenceName, this.belongsToTable);
        sequence.setStartValue(this.start);
        sequence.setIncrement(this.increment);
        sequence.setCacheSize(this.cacheSize);
        db.addSchemaObject(this.session, sequence);
        return 0;
    }

    public void setStartWith(long start) {
        this.start = start;
    }

    public void setIncrement(long increment) {
        this.increment = increment;
    }

    public void setBelongsToTable(boolean belongsToTable) {
        this.belongsToTable = belongsToTable;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }
}

