/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.text.Collator;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    public boolean isTransactional() {
        return false;
    }

    public int update() throws SQLException {
        Database database = this.session.getDatabase();
        String name = SetTypes.getTypeName(this.type);
        switch (this.type) {
            case 2: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 5: {
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelFile(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int size = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 3: {
                this.session.getUser().checkAdmin();
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw Message.getSQLException(90088, this.stringValue);
                }
                database.setMode(mode);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                ObjectArray array = database.getAllSchemaObjects(0);
                for (int i = 0; i < array.size(); ++i) {
                    Table table = (Table)array.get(i);
                    if (table.getCreateSQL() == null) continue;
                    throw Message.getSQLException(90089, table.getSQL());
                }
                StringBuffer buff = new StringBuffer(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = new CompareMode(null, null);
                } else {
                    Collator coll = CompareMode.getCollator(this.stringValue);
                    compareMode = new CompareMode(coll, this.stringValue);
                    buff.append(" STRENGTH ");
                    if (this.getIntValue() == 3) {
                        buff.append("IDENTICAL");
                    } else if (this.getIntValue() == 0) {
                        buff.append("PRIMARY");
                    } else if (this.getIntValue() == 1) {
                        buff.append("SECONDARY");
                    } else if (this.getIntValue() == 2) {
                        buff.append("TERTIARY");
                    }
                    coll.setStrength(this.getIntValue());
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                database.setCluster(StringUtils.quoteStringSQL(this.stringValue));
                this.addOrUpdateSetting(name, StringUtils.quoteStringSQL(this.stringValue), 0);
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListener(this.stringValue);
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(this.getIntValue() == 1);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 19: {
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "LOG");
                }
                if (value == 0) {
                    this.session.getUser().checkAdmin();
                }
                database.setLog(value);
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "THROTTLE");
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "MAX_MEMORY_UNDO");
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "MAX_LENGTH_INPLACE_LOB");
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int algo = CompressTool.getInstance().getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(algo == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                break;
            }
            case 24: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "ALLOW_LITERALS");
                }
                database.setAllowLiterals(value);
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 29: {
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "UNDO_LOG");
                }
                this.session.setUndoLogEnabled(value == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "REFERENTIAL_INTEGRITY");
                }
                database.setReferentialIntegrity(value == 1);
                break;
            }
            case 31: {
                if (database.isMultiVersion() == (this.getIntValue() == 1)) break;
                throw Message.getSQLException(90133, "MVCC");
            }
            case 32: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                database.setMaxOperationMemory(value);
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                database.setExclusiveSession(value == 1 ? this.session : null);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private int getIntValue() throws SQLException {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInt.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s, int v) throws SQLException {
        Database database = this.session.getDatabase();
        if (database.getReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId(false, true);
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(this.session, setting);
        } else {
            database.update(this.session, setting);
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public LocalResult queryMeta() {
        return null;
    }

    public void setStringArray(String[] list) {
        this.stringValueList = list;
    }
}

