/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.store.fs.FileSystem;
import org.h2.util.MathUtils;
import org.h2.util.SortedProperties;

public class FileUtils {
    public static void setLength(RandomAccessFile file, long newLength) throws IOException {
        try {
            FileUtils.trace("setLength", null, file);
            file.setLength(newLength);
        }
        catch (IOException e) {
            int write;
            long remaining;
            long length = file.length();
            if (newLength < length) {
                throw e;
            }
            long pos = file.getFilePointer();
            file.seek(length);
            int maxSize = 0x100000;
            int block = (int)Math.min(remaining, (long)maxSize);
            byte[] buffer = new byte[block];
            for (remaining = newLength - length; remaining > 0L; remaining -= (long)write) {
                write = (int)Math.min(remaining, (long)maxSize);
                file.write(buffer, 0, write);
            }
            file.seek(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadProperties(String fileName) throws IOException {
        SortedProperties prop = new SortedProperties();
        if (FileUtils.exists(fileName)) {
            InputStream in = FileUtils.openFileInputStream(fileName);
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        return prop;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static int getIntProperty(Properties prop, String key, int def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return MathUtils.decodeInt(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static String getFileInUserHome(String fileName) {
        String userDir = SysProperties.USER_HOME;
        if (userDir == null) {
            return fileName;
        }
        File file = new File(userDir, fileName);
        return file.getAbsolutePath();
    }

    public static void trace(String method, String fileName, Object o) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileUtils." + method + " " + fileName + " " + o);
        }
    }

    public static Reader openFileReader(String fileName) throws IOException {
        InputStreamReader reader = new InputStreamReader(FileUtils.openFileInputStream(fileName));
        return new BufferedReader(reader);
    }

    public static String getFileName(String name) throws SQLException {
        return FileSystem.getInstance(name).getFileName(name);
    }

    public static String normalize(String fileName) throws SQLException {
        return FileSystem.getInstance(fileName).normalize(fileName);
    }

    public static void tryDelete(String fileName) {
        FileSystem.getInstance(fileName).tryDelete(fileName);
    }

    public static boolean isReadOnly(String fileName) {
        return FileSystem.getInstance(fileName).isReadOnly(fileName);
    }

    public static boolean exists(String fileName) {
        return FileSystem.getInstance(fileName).exists(fileName);
    }

    public static long length(String fileName) {
        return FileSystem.getInstance(fileName).length(fileName);
    }

    public static String createTempFile(String prefix, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException, SQLException {
        return FileSystem.getInstance(prefix).createTempFile(prefix, suffix, deleteOnExit, inTempDir);
    }

    public static String getParent(String fileName) {
        return FileSystem.getInstance(fileName).getParent(fileName);
    }

    public static String[] listFiles(String path) throws SQLException {
        return FileSystem.getInstance(path).listFiles(path);
    }

    public static boolean isDirectory(String fileName) {
        return FileSystem.getInstance(fileName).isDirectory(fileName);
    }

    public static boolean isAbsolute(String fileName) {
        return FileSystem.getInstance(fileName).isAbsolute(fileName);
    }

    public static String getAbsolutePath(String fileName) {
        return FileSystem.getInstance(fileName).getAbsolutePath(fileName);
    }

    public static Writer openFileWriter(String fileName, boolean append) throws SQLException {
        OutputStream out = FileSystem.getInstance(fileName).openFileOutputStream(fileName, append);
        return new BufferedWriter(new OutputStreamWriter(out));
    }

    public static boolean fileStartsWith(String fileName, String prefix) {
        return FileSystem.getInstance(fileName).fileStartsWith(fileName, prefix);
    }

    public static InputStream openFileInputStream(String fileName) throws IOException {
        return FileSystem.getInstance(fileName).openFileInputStream(fileName);
    }

    public static OutputStream openFileOutputStream(String fileName, boolean append) throws SQLException {
        return FileSystem.getInstance(fileName).openFileOutputStream(fileName, append);
    }

    public static void rename(String oldName, String newName) throws SQLException {
        FileSystem.getInstance(oldName).rename(oldName, newName);
    }

    public static void createDirs(String fileName) throws SQLException {
        FileSystem.getInstance(fileName).createDirs(fileName);
    }

    public static void delete(String fileName) throws SQLException {
        FileSystem.getInstance(fileName).delete(fileName);
    }
}

