/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.tree;

import java.util.Map;
import java.util.Random;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.classification.meta.Bagging;
import net.sf.javaml.classification.tree.RandomTree;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class RandomForest
implements Classifier {
    private static final long serialVersionUID = 5832370995432897745L;
    private Bagging bagger;
    private int treeCount;
    private int numAttributes;
    private boolean calculateOutOfBagErrorEstimate = false;
    private Random rg;

    public void setNumAttributes(int k) {
        this.numAttributes = k;
    }

    public RandomForest(int treeCount) {
        this(treeCount, false, 1, new Random(System.currentTimeMillis()));
    }

    public RandomForest(int treeCount, boolean calculateOutOfBagErrorEstimate, int numAttributes, Random rg) {
        this.treeCount = treeCount;
        this.rg = rg;
        this.calculateOutOfBagErrorEstimate = calculateOutOfBagErrorEstimate;
        this.numAttributes = numAttributes;
    }

    public double getOutOfBagErrorEstimate() {
        return this.bagger.getOutOfBagErrorEstimate();
    }

    @Override
    public void buildClassifier(Dataset data) {
        if (this.treeCount < 0) {
            this.treeCount = (int)Math.sqrt(data.noAttributes()) + 1;
        }
        Classifier[] trees = new RandomTree[this.treeCount];
        for (int i = 0; i < trees.length; ++i) {
            trees[i] = new RandomTree(this.numAttributes, this.rg);
        }
        this.bagger = new Bagging(trees, this.rg);
        this.bagger.setCalculateOutOfBagErrorEstimate(this.calculateOutOfBagErrorEstimate);
        this.bagger.buildClassifier(data);
    }

    @Override
    public Object classify(Instance instance) {
        return this.bagger.classify(instance);
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        return this.bagger.classDistribution(instance);
    }
}

