/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import java.util.Random;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;
import net.sf.javaml.tools.DatasetTools;

public class KMeans
implements Clusterer {
    private int numberOfClusters = -1;
    private int numberOfIterations = -1;
    private Random rg;
    private DistanceMeasure dm;
    private Instance[] centroids;

    public KMeans() {
        this(4);
    }

    public KMeans(int k) {
        this(k, 100);
    }

    public KMeans(int clusters, int iterations) {
        this(clusters, iterations, new EuclideanDistance());
    }

    public KMeans(int clusters, int iterations, DistanceMeasure dm) {
        this.numberOfClusters = clusters;
        this.numberOfIterations = iterations;
        this.dm = dm;
        this.rg = new Random(System.currentTimeMillis());
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        int i;
        double dist;
        if (data.size() == 0) {
            throw new RuntimeException("The dataset should not be empty");
        }
        if (this.numberOfClusters == 0) {
            throw new RuntimeException("There should be at least one cluster");
        }
        Instance min = DatasetTools.minAttributes(data);
        Instance max = DatasetTools.maxAttributes(data);
        this.centroids = new Instance[this.numberOfClusters];
        int instanceLength = data.instance(0).noAttributes();
        for (int j = 0; j < this.numberOfClusters; ++j) {
            double[] randomInstance = DatasetTools.getRandomInstance(data, this.rg);
            this.centroids[j] = new DenseInstance(randomInstance);
        }
        int iterationCount = 0;
        boolean centroidsChanged = true;
        boolean randomCentroids = true;
        while (randomCentroids || iterationCount < this.numberOfIterations && centroidsChanged) {
            int i2;
            int j;
            ++iterationCount;
            int[] assignment = new int[data.size()];
            for (int i3 = 0; i3 < data.size(); ++i3) {
                int tmpCluster = 0;
                double minDistance = this.dm.measure(this.centroids[0], data.instance(i3));
                for (j = 1; j < this.centroids.length; ++j) {
                    dist = this.dm.measure(this.centroids[j], data.instance(i3));
                    if (!this.dm.compare(dist, minDistance)) continue;
                    minDistance = dist;
                    tmpCluster = j;
                }
                assignment[i3] = tmpCluster;
            }
            double[][] sumPosition = new double[this.numberOfClusters][instanceLength];
            int[] countPosition = new int[this.numberOfClusters];
            for (i2 = 0; i2 < data.size(); ++i2) {
                Instance in = data.instance(i2);
                for (j = 0; j < instanceLength; ++j) {
                    double[] dArray = sumPosition[assignment[i2]];
                    int n = j;
                    dArray[n] = dArray[n] + in.value(j);
                }
                int n = assignment[i2];
                countPosition[n] = countPosition[n] + 1;
            }
            centroidsChanged = false;
            randomCentroids = false;
            for (i2 = 0; i2 < this.numberOfClusters; ++i2) {
                if (countPosition[i2] > 0) {
                    double[] tmp = new double[instanceLength];
                    for (int j2 = 0; j2 < instanceLength; ++j2) {
                        tmp[j2] = (float)sumPosition[i2][j2] / (float)countPosition[i2];
                    }
                    DenseInstance newCentroid = new DenseInstance(tmp);
                    if (!(this.dm.measure(newCentroid, this.centroids[i2]) > 1.0E-4)) continue;
                    centroidsChanged = true;
                    this.centroids[i2] = newCentroid;
                    continue;
                }
                double[] randomInstance = new double[instanceLength];
                for (int j3 = 0; j3 < instanceLength; ++j3) {
                    dist = Math.abs(max.value(j3) - min.value(j3));
                    randomInstance[j3] = (float)(min.value(j3) + this.rg.nextDouble() * dist);
                }
                randomCentroids = true;
                this.centroids[i2] = new DenseInstance(randomInstance);
            }
        }
        Dataset[] output = new Dataset[this.centroids.length];
        for (i = 0; i < this.centroids.length; ++i) {
            output[i] = new DefaultDataset();
        }
        for (i = 0; i < data.size(); ++i) {
            int tmpCluster = 0;
            double minDistance = this.dm.measure(this.centroids[0], data.instance(i));
            for (int j = 0; j < this.centroids.length; ++j) {
                dist = this.dm.measure(this.centroids[j], data.instance(i));
                if (!this.dm.compare(dist, minDistance)) continue;
                minDistance = dist;
                tmpCluster = j;
            }
            output[tmpCluster].add(data.instance(i));
        }
        return output;
    }
}

