/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.clustering.KMeans;
import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class MultiKMeans
implements Clusterer {
    private int repeats;
    private int clusters;
    private int iterations;
    private DistanceMeasure dm;
    private ClusterEvaluation ce;

    public MultiKMeans(ClusterEvaluation ce) {
        this(4, 100, 10, new EuclideanDistance(), ce);
    }

    public MultiKMeans(int clusters, int iterations, int repeats, DistanceMeasure dm, ClusterEvaluation ce) {
        this.clusters = clusters;
        this.iterations = iterations;
        this.repeats = repeats;
        this.dm = dm;
        this.ce = ce;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        KMeans km = new KMeans(this.clusters, this.iterations, this.dm);
        Dataset[] bestClusters = km.cluster(data);
        double bestScore = this.ce.score(bestClusters);
        for (int i = 0; i < this.repeats; ++i) {
            Dataset[] tmpClusters = km.cluster(data);
            double tmpScore = this.ce.score(tmpClusters);
            if (!this.ce.compareScore(bestScore, tmpScore)) continue;
            bestScore = tmpScore;
            bestClusters = tmpClusters;
        }
        return bestClusters;
    }
}

