/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class GPlus
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public GPlus(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        int k;
        Instance x;
        int j;
        int i;
        double maxIntraDist = Double.MIN_VALUE;
        double sMin = 0.0;
        double fw = 0.0;
        double fb = 0.0;
        for (i = 0; i < datas.length; ++i) {
            for (j = 0; j < datas[i].size(); ++j) {
                x = datas[i].instance(j);
                for (k = j + 1; k < datas[i].size(); ++k) {
                    fw += 1.0;
                    Instance y = datas[i].instance(k);
                    double distance = this.dm.measure(x, y);
                    if (!(maxIntraDist < distance)) continue;
                    maxIntraDist = distance;
                }
            }
        }
        for (i = 0; i < datas.length; ++i) {
            for (j = 0; j < datas[i].size(); ++j) {
                x = datas[i].instance(j);
                for (k = i + 1; k < datas.length; ++k) {
                    for (int l = 0; l < datas[k].size(); ++l) {
                        Instance y = datas[k].instance(l);
                        fb += 1.0;
                        double distance = this.dm.measure(x, y);
                        if (!(distance < maxIntraDist)) continue;
                        sMin += 1.0;
                    }
                }
            }
        }
        double nd = fw + fb;
        double gPlus = 2.0 * sMin / (nd * (nd - 1.0));
        return gPlus;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

