/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class WB
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public WB(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        double dw = 0.0;
        double fw = 0.0;
        double db = 0.0;
        double fb = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].size(); ++j) {
                int k;
                Instance x = datas[i].instance(j);
                for (k = j + 1; k < datas[i].size(); ++k) {
                    Instance y = datas[i].instance(k);
                    double distance = this.dm.measure(x, y);
                    dw += distance;
                    fw += 1.0;
                }
                for (k = i + 1; k < datas.length; ++k) {
                    for (int l = 0; l < datas[k].size(); ++l) {
                        Instance y = datas[k].instance(l);
                        double distance = this.dm.measure(x, y);
                        db += distance;
                        fb += 1.0;
                    }
                }
            }
        }
        double wb = dw / fw / (db / fb);
        return wb;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

