/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Fold;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;

public class DefaultDataset
extends Vector<Instance>
implements Dataset {
    private int maxAttributes = 0;
    private static final long serialVersionUID = 8586030444860912681L;
    private TreeSet<Object> classes = new TreeSet();

    public DefaultDataset(Collection<Instance> coll) {
        this.addAll((Collection<? extends Instance>)coll);
    }

    public DefaultDataset() {
    }

    private void check(Collection<? extends Instance> c) {
        for (Instance instance : c) {
            this.check(instance);
        }
    }

    private void check(Instance i) {
        if (i.classValue() != null) {
            this.classes.add(i.classValue());
        }
        if (i.noAttributes() > this.maxAttributes) {
            this.maxAttributes = i.noAttributes();
        }
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Instance> c) {
        this.check(c);
        return super.addAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends Instance> c) {
        this.check(c);
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        this.classes.clear();
        super.clear();
    }

    @Override
    public synchronized boolean add(Instance e) {
        this.check(e);
        return super.add(e);
    }

    @Override
    public void add(int index, Instance e) {
        this.check(e);
        super.add(index, e);
    }

    @Override
    public synchronized void addElement(Instance e) {
        this.check(e);
        super.addElement(e);
    }

    @Override
    public synchronized void insertElementAt(Instance e, int index) {
        this.check(e);
        super.insertElementAt(e, index);
    }

    @Override
    public synchronized void setElementAt(Instance e, int index) {
        this.check(e);
        super.setElementAt(e, index);
    }

    @Override
    public Instance instance(int index) {
        return (Instance)super.get(index);
    }

    @Override
    public SortedSet<Object> classes() {
        return this.classes;
    }

    @Override
    public Set<Instance> kNearest(int k, Instance inst, DistanceMeasure dm) {
        HashMap<Instance, Double> closest = new HashMap<Instance, Double>();
        double max = dm.getMaxValue();
        for (Instance tmp : this) {
            double d = dm.measure(inst, tmp);
            if (!dm.compare(d, max) || inst.equals(tmp)) continue;
            closest.put(tmp, d);
            if (closest.size() <= k) continue;
            max = this.removeFarthest(closest, dm);
        }
        return closest.keySet();
    }

    private double removeFarthest(Map<Instance, Double> vector, DistanceMeasure dm) {
        Instance tmp = null;
        double max = dm.getMinValue();
        for (Instance inst : vector.keySet()) {
            double d = vector.get(inst);
            if (!dm.compare(max, d)) continue;
            max = d;
            tmp = inst;
        }
        vector.remove(tmp);
        return max;
    }

    @Override
    public Dataset[] folds(int numFolds, Random rg) {
        int i;
        Dataset[] out = new Dataset[numFolds];
        Vector<Integer> indices = new Vector<Integer>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            indices.add(i2);
        }
        int size = this.size() / numFolds + 1;
        int[][] array = new int[numFolds][size];
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < numFolds; ++j) {
                array[j][i] = indices.size() > 0 ? (Integer)indices.remove(rg.nextInt(indices.size())) : -1;
            }
        }
        for (i = 0; i < numFolds; ++i) {
            int[] indi;
            if (array[i][size - 1] == -1) {
                indi = new int[size - 1];
                System.arraycopy(array[i], 0, indi, 0, size - 1);
            } else {
                indi = new int[size];
                System.arraycopy(array[i], 0, indi, 0, size);
            }
            out[i] = new Fold(this, indi);
        }
        return out;
    }

    @Override
    public int noAttributes() {
        if (this.size() == 0) {
            return 0;
        }
        return this.maxAttributes;
    }

    @Override
    public int classIndex(Object clazz) {
        if (clazz != null) {
            return this.classes().headSet(clazz).size();
        }
        return -1;
    }

    @Override
    public Object classValue(int index) {
        int i = 0;
        for (Object o : this.classes) {
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Dataset copy() {
        DefaultDataset out = new DefaultDataset();
        for (Instance i : this) {
            out.add(i.copy());
        }
        return out;
    }
}

