/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core.kdtree;

import java.util.Vector;
import net.sf.javaml.core.kdtree.HPoint;
import net.sf.javaml.core.kdtree.HRect;
import net.sf.javaml.core.kdtree.NearestNeighborList;

class KDNode {
    protected HPoint k;
    Object v;
    protected KDNode left;
    protected KDNode right;
    protected boolean deleted;

    protected static KDNode ins(HPoint key, Object val, KDNode t, int lev, int K) {
        if (t == null) {
            t = new KDNode(key, val);
        } else if (key.equals(t.k)) {
            if (t.deleted) {
                t.deleted = false;
                t.v = val;
            }
        } else if (key.coord[lev] > t.k.coord[lev]) {
            t.right = KDNode.ins(key, val, t.right, (lev + 1) % K, K);
        } else {
            t.left = KDNode.ins(key, val, t.left, (lev + 1) % K, K);
        }
        return t;
    }

    protected static KDNode srch(HPoint key, KDNode t, int K) {
        int lev = 0;
        while (t != null) {
            if (!t.deleted && key.equals(t.k)) {
                return t;
            }
            t = key.coord[lev] > t.k.coord[lev] ? t.right : t.left;
            lev = (lev + 1) % K;
        }
        return null;
    }

    protected static void rsearch(HPoint lowk, HPoint uppk, KDNode t, int lev, int K, Vector<KDNode> v) {
        int j;
        if (t == null) {
            return;
        }
        if (lowk.coord[lev] <= t.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t.left, (lev + 1) % K, K, v);
        }
        for (j = 0; j < K && lowk.coord[j] <= t.k.coord[j] && uppk.coord[j] >= t.k.coord[j]; ++j) {
        }
        if (j == K) {
            v.add(t);
        }
        if (uppk.coord[lev] > t.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t.right, (lev + 1) % K, K, v);
        }
    }

    protected static void nnbr(KDNode kd, HPoint target, HRect hr, double max_dist_sqd, int lev, int K, NearestNeighborList nnl) {
        HRect further_hr;
        KDNode further_kd;
        HRect nearer_hr;
        KDNode nearer_kd;
        boolean target_in_left;
        if (kd == null) {
            return;
        }
        int s = lev % K;
        HPoint pivot = kd.k;
        double pivot_to_target = HPoint.sqrdist(pivot, target);
        HRect left_hr = hr;
        HRect right_hr = (HRect)hr.clone();
        left_hr.max.coord[s] = pivot.coord[s];
        right_hr.min.coord[s] = pivot.coord[s];
        boolean bl = target_in_left = target.coord[s] < pivot.coord[s];
        if (target_in_left) {
            nearer_kd = kd.left;
            nearer_hr = left_hr;
            further_kd = kd.right;
            further_hr = right_hr;
        } else {
            nearer_kd = kd.right;
            nearer_hr = right_hr;
            further_kd = kd.left;
            further_hr = left_hr;
        }
        KDNode.nnbr(nearer_kd, target, nearer_hr, max_dist_sqd, lev + 1, K, nnl);
        KDNode nearest = (KDNode)nnl.getHighest();
        double dist_sqd = !nnl.isCapacityReached() ? Double.MAX_VALUE : nnl.getMaxPriority();
        max_dist_sqd = Math.min(max_dist_sqd, dist_sqd);
        HPoint closest = further_hr.closest(target);
        if (HPoint.eucdist(closest, target) < Math.sqrt(max_dist_sqd)) {
            if (pivot_to_target < dist_sqd) {
                nearest = kd;
                dist_sqd = pivot_to_target;
                if (!kd.deleted) {
                    nnl.insert(kd, dist_sqd);
                }
                max_dist_sqd = nnl.isCapacityReached() ? nnl.getMaxPriority() : Double.MAX_VALUE;
            }
            KDNode.nnbr(further_kd, target, further_hr, max_dist_sqd, lev + 1, K, nnl);
            KDNode temp_nearest = (KDNode)nnl.getHighest();
            double temp_dist_sqd = nnl.getMaxPriority();
            if (temp_dist_sqd < dist_sqd) {
                nearest = temp_nearest;
                dist_sqd = temp_dist_sqd;
            }
        } else if (pivot_to_target < max_dist_sqd) {
            nearest = kd;
            dist_sqd = pivot_to_target;
        }
    }

    private KDNode(HPoint key, Object val) {
        this.k = key;
        this.v = val;
        this.left = null;
        this.right = null;
        this.deleted = false;
    }

    protected String toString(int depth) {
        String s = this.k + "  " + this.v + (this.deleted ? "*" : "");
        if (this.left != null) {
            s = s + "\n" + KDNode.pad(depth) + "L " + this.left.toString(depth + 1);
        }
        if (this.right != null) {
            s = s + "\n" + KDNode.pad(depth) + "R " + this.right.toString(depth + 1);
        }
        return s;
    }

    private static String pad(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + " ";
        }
        return s;
    }

    private static void hrcopy(HRect hr_src, HRect hr_dst) {
        KDNode.hpcopy(hr_src.min, hr_dst.min);
        KDNode.hpcopy(hr_src.max, hr_dst.max);
    }

    private static void hpcopy(HPoint hp_src, HPoint hp_dst) {
        for (int i = 0; i < hp_dst.coord.length; ++i) {
            hp_dst.coord[i] = hp_src.coord[i];
        }
    }
}

