/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.EuclideanDistance;
import net.sf.javaml.tools.DatasetTools;

public class NormalizedEuclideanDistance
extends EuclideanDistance {
    private static final long serialVersionUID = -6489071802740149683L;
    private Dataset data;

    public NormalizedEuclideanDistance(Dataset data) {
        this.data = data;
    }

    @Override
    public double measure(Instance i, Instance j) {
        Instance min = DatasetTools.minAttributes(this.data);
        Instance max = DatasetTools.maxAttributes(this.data);
        Instance normI = this.normalizeMidrange(0.5, 1.0, min, max, i);
        Instance normJ = this.normalizeMidrange(0.5, 1.0, min, max, j);
        return super.calculateDistance(normI, normJ) / Math.sqrt(i.noAttributes());
    }

    private Instance normalizeMidrange(double normalMiddle, double normalRange, Instance min, Instance max, Instance instance) {
        double[] out = new double[instance.noAttributes()];
        for (int i = 0; i < out.length; ++i) {
            double range = Math.abs(max.value(i) - min.value(i));
            double middle = Math.abs(max.value(i) + min.value(i)) / 2.0;
            out[i] = (instance.value(i) - middle) / range * normalRange + normalMiddle;
        }
        return new DenseInstance(out, instance);
    }
}

