/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractSimilarity;

public class RBFKernel
extends AbstractSimilarity {
    private static final long serialVersionUID = -4365058705250608462L;
    private double gamma = 0.01;

    public RBFKernel() {
        this(0.01);
    }

    public RBFKernel(double gamma) {
        this.gamma = gamma;
    }

    private final double dotProduct(Instance x, Instance y) {
        double result = 0.0;
        for (int i = 0; i < x.noAttributes(); ++i) {
            result += x.value(i) * y.value(i);
        }
        return result;
    }

    @Override
    public double measure(Instance x, Instance y) {
        if (x.equals(y)) {
            return 1.0;
        }
        double result = Math.exp(this.gamma * (2.0 * this.dotProduct(x, y) - this.dotProduct(x, x) - this.dotProduct(y, y)));
        return result;
    }
}

