/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractDistance;

public class SpearmanFootruleDistance
extends AbstractDistance {
    private static final long serialVersionUID = -6347213714272482397L;

    @Override
    public double measure(Instance a, Instance b) {
        if (a.noAttributes() != b.noAttributes()) {
            throw new IllegalArgumentException("Instances should be compatible.");
        }
        long k = a.noAttributes();
        long denom = k % 2L == 0L ? k * k / 2L : (k + 1L) * (k - 1L) / 2L;
        double sum = 0.0;
        for (int i = 0; i < a.noAttributes(); ++i) {
            double diff = Math.abs(a.value(i) - b.value(i));
            sum += diff;
        }
        return 1.0 - sum / (double)denom;
    }

    public double getMaximumDistance(Dataset data) {
        return 1.0;
    }

    public double getMinimumDistance(Dataset data) {
        return 0.0;
    }
}

