/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw;

import java.util.ArrayList;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractDistance;
import net.sf.javaml.distance.fastdtw.dtw.DTW;
import net.sf.javaml.distance.fastdtw.dtw.TimeWarpInfo;
import net.sf.javaml.distance.fastdtw.dtw.WarpPath;
import net.sf.javaml.distance.fastdtw.dtw.WarpPathWindow;
import net.sf.javaml.distance.fastdtw.timeseries.PAA;
import net.sf.javaml.distance.fastdtw.timeseries.TimeSeries;

public class Abstraction
extends AbstractDistance {
    private int radius = 5;
    private static final long serialVersionUID = -4864690770638592535L;

    public Abstraction(int radius) {
        this.radius = radius;
    }

    @Override
    public double measure(Instance x, Instance y) {
        TimeSeries tsI = new TimeSeries(x);
        TimeSeries tsJ = new TimeSeries(y);
        PAA shrunkI = new PAA(tsI, (int)Math.round(Math.sqrt(tsI.size())));
        PAA shrunkJ = new PAA(tsJ, (int)Math.round(Math.sqrt(tsJ.size())));
        WarpPath coarsePath = DTW.getWarpPathBetween(shrunkI, shrunkJ);
        WarpPath expandedPath = Abstraction.expandPath(coarsePath, shrunkI, shrunkJ);
        WarpPathWindow w = new WarpPathWindow(expandedPath, this.radius);
        TimeWarpInfo info = DTW.getWarpInfoBetween(tsI, tsJ, w);
        System.out.println("Warp Distance: " + info.getDistance());
        System.out.println("Warp Path:     " + info.getPath());
        return info.getDistance();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("USAGE:  java Abstraction timeSeries1 timeSeries2 radius");
            System.exit(1);
        } else {
            TimeSeries tsI = new TimeSeries(args[0], false, false, ',');
            TimeSeries tsJ = new TimeSeries(args[1], false, false, ',');
            PAA shrunkI = new PAA(tsI, (int)Math.round(Math.sqrt(tsI.size())));
            PAA shrunkJ = new PAA(tsJ, (int)Math.round(Math.sqrt(tsJ.size())));
            WarpPath coarsePath = DTW.getWarpPathBetween(shrunkI, shrunkJ);
            WarpPath expandedPath = Abstraction.expandPath(coarsePath, shrunkI, shrunkJ);
            WarpPathWindow w = new WarpPathWindow(expandedPath, Integer.parseInt(args[2]));
            TimeWarpInfo info = DTW.getWarpInfoBetween(tsI, tsJ, w);
            System.out.println("Warp Distance: " + info.getDistance());
            System.out.println("Warp Path:     " + info.getPath());
        }
    }

    private static WarpPath expandPath(WarpPath path, PAA tsI, PAA tsJ) {
        ArrayList<Integer> iPoints = new ArrayList<Integer>();
        ArrayList<Integer> jPoints = new ArrayList<Integer>();
        iPoints.add(new Integer(0));
        jPoints.add(new Integer(0));
        int startI = 0;
        int startJ = 0;
        startI = path.get(1).getCol() != 0 ? tsI.aggregatePtSize(0) - 1 : (tsI.aggregatePtSize(0) - 1) / 2;
        startJ = path.get(1).getRow() != 0 ? tsJ.aggregatePtSize(0) - 1 : (tsJ.aggregatePtSize(0) - 1) / 2;
        int lastI = 0;
        int lastJ = 0;
        for (int x = 1; x < path.size() - 1; ++x) {
            int currentI = path.get(x).getCol();
            int currentJ = path.get(x).getRow();
            if (lastI != currentI) {
                if (lastI == 0) {
                    startI = tsI.aggregatePtSize(0) - 1;
                }
                if (currentI == path.get(path.size() - 1).getCol()) {
                    startI -= tsI.aggregatePtSize(currentI) / 2;
                }
                iPoints.add(new Integer(startI + tsI.aggregatePtSize(currentI) / 2));
                startI += tsI.aggregatePtSize(currentI);
                lastI = currentI;
            } else {
                iPoints.add(new Integer(startI));
            }
            if (lastJ != currentJ) {
                if (lastJ == 0) {
                    startJ = tsJ.aggregatePtSize(0) - 1;
                }
                if (currentJ == path.get(path.size() - 1).getRow()) {
                    startJ -= tsJ.aggregatePtSize(currentJ) / 2;
                }
                jPoints.add(new Integer(startJ + tsJ.aggregatePtSize(currentJ) / 2));
                startJ += tsJ.aggregatePtSize(currentJ);
                lastJ = currentJ;
                continue;
            }
            jPoints.add(new Integer(startJ));
        }
        iPoints.add(new Integer(tsI.originalSize() - 1));
        jPoints.add(new Integer(tsJ.originalSize() - 1));
        WarpPath expandedPath = new WarpPath();
        startI = 0;
        startJ = 0;
        for (int p = 1; p < iPoints.size(); ++p) {
            int endI = (Integer)iPoints.get(p);
            int endJ = (Integer)jPoints.get(p);
            expandedPath.addLast(startI, startJ);
            if (endI - startI >= endJ - startJ) {
                for (int i = startI + 1; i < endI; ++i) {
                    expandedPath.addLast(i, (int)Math.round((double)startJ + ((double)i - (double)startI) / ((double)endI - (double)startI) * (double)(endJ - startJ)));
                }
            } else {
                for (int j = startJ + 1; j < endJ; ++j) {
                    expandedPath.addLast((int)Math.round((double)startI + ((double)j - (double)startJ) / ((double)endJ - (double)startJ) * (double)(endI - startI)), j);
                }
            }
            startI = endI;
            startJ = endJ;
        }
        expandedPath.addLast(tsI.originalSize() - 1, tsJ.originalSize() - 1);
        return expandedPath;
    }
}

