/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw;

import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractDistance;
import net.sf.javaml.distance.fastdtw.dtw.DTW;
import net.sf.javaml.distance.fastdtw.dtw.LinearWindow;
import net.sf.javaml.distance.fastdtw.dtw.TimeWarpInfo;
import net.sf.javaml.distance.fastdtw.timeseries.TimeSeries;

public class Band
extends AbstractDistance {
    private static final long serialVersionUID = 1279757837120934014L;
    private int radius = 5;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("USAGE:  java Band timeSeries1 timeSeries2 radius");
            System.exit(1);
        } else {
            TimeSeries tsI = new TimeSeries(args[0], false, false, ',');
            TimeSeries tsJ = new TimeSeries(args[1], false, false, ',');
            TimeWarpInfo info = DTW.getWarpInfoBetween(tsI, tsJ, new LinearWindow(tsI, tsJ, Integer.parseInt(args[2])));
            System.out.println("Warp Distance: " + info.getDistance());
            System.out.println("Warp Path:     " + info.getPath());
        }
    }

    public Band(int radius) {
        this.radius = radius;
    }

    @Override
    public double measure(Instance x, Instance y) {
        TimeSeries tsI = new TimeSeries(x);
        TimeSeries tsJ = new TimeSeries(y);
        TimeWarpInfo info = DTW.getWarpInfoBetween(tsI, tsJ, new LinearWindow(tsI, tsJ, this.radius));
        System.out.println("Warp Distance: " + info.getDistance());
        System.out.println("Warp Path:     " + info.getPath());
        return info.getDistance();
    }
}

