/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw.dtw;

import java.util.Iterator;
import net.sf.javaml.distance.fastdtw.dtw.PartialWindowMatrix;
import net.sf.javaml.distance.fastdtw.dtw.SearchWindow;
import net.sf.javaml.distance.fastdtw.dtw.TimeWarpInfo;
import net.sf.javaml.distance.fastdtw.dtw.WarpPath;
import net.sf.javaml.distance.fastdtw.dtw.WindowMatrix;
import net.sf.javaml.distance.fastdtw.matrix.ColMajorCell;
import net.sf.javaml.distance.fastdtw.timeseries.TimeSeries;

public class DTW {
    public static double calcWarpCost(WarpPath path, TimeSeries tsI, TimeSeries tsJ) {
        double totalCost = 0.0;
        for (int p = 0; p < path.size(); ++p) {
            ColMajorCell currWarp = path.get(p);
            totalCost += DTW.euclideanDist(tsI.getMeasurementVector(currWarp.getCol()), tsJ.getMeasurementVector(currWarp.getRow()));
        }
        return totalCost;
    }

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ) {
        if (tsI.size() < tsJ.size()) {
            return DTW.getWarpDistBetween(tsJ, tsI);
        }
        double[] lastCol = new double[tsJ.size()];
        double[] currCol = new double[tsJ.size()];
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        currCol[0] = DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(0));
        for (int j = 1; j <= maxJ; ++j) {
            currCol[j] = currCol[j - 1] + DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(j));
        }
        for (int i = 1; i <= maxI; ++i) {
            double[] temp = lastCol;
            lastCol = currCol;
            currCol = temp;
            currCol[0] = lastCol[0] + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(0));
            for (int j = 1; j <= maxJ; ++j) {
                double minGlobalCost = Math.min(lastCol[j], Math.min(lastCol[j - 1], currCol[j - 1]));
                currCol[j] = minGlobalCost + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(j));
            }
        }
        return currCol[maxJ];
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ) {
        return DTW.DynamicTimeWarp(tsI, tsJ).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries tsI, TimeSeries tsJ) {
        return DTW.DynamicTimeWarp(tsI, tsJ);
    }

    private static TimeWarpInfo DynamicTimeWarp(TimeSeries tsI, TimeSeries tsJ) {
        double[][] costMatrix = new double[tsI.size()][tsJ.size()];
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        costMatrix[0][0] = DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(0));
        for (int j = 1; j <= maxJ; ++j) {
            costMatrix[0][j] = costMatrix[0][j - 1] + DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(j));
        }
        for (int i = 1; i <= maxI; ++i) {
            costMatrix[i][0] = costMatrix[i - 1][0] + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(0));
            for (int j = 1; j <= maxJ; ++j) {
                double minGlobalCost = Math.min(costMatrix[i - 1][j], Math.min(costMatrix[i - 1][j - 1], costMatrix[i][j - 1]));
                costMatrix[i][j] = minGlobalCost + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(j));
            }
        }
        double minimumCost = costMatrix[maxI][maxJ];
        WarpPath minCostPath = new WarpPath(maxI + maxJ - 1);
        int i = maxI;
        int j = maxJ;
        minCostPath.addFirst(i, j);
        while (i > 0 || j > 0) {
            double diagCost = i > 0 && j > 0 ? costMatrix[i - 1][j - 1] : Double.POSITIVE_INFINITY;
            double leftCost = i > 0 ? costMatrix[i - 1][j] : Double.POSITIVE_INFINITY;
            double downCost = j > 0 ? costMatrix[i][j - 1] : Double.POSITIVE_INFINITY;
            if (diagCost <= leftCost && diagCost <= downCost) {
                --i;
                --j;
            } else if (leftCost < diagCost && leftCost < downCost) {
                --i;
            } else if (downCost < diagCost && downCost < leftCost) {
                --j;
            } else if (i <= j) {
                --j;
            } else {
                --i;
            }
            minCostPath.addFirst(i, j);
        }
        return new TimeWarpInfo(minimumCost, minCostPath);
    }

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ, SearchWindow window) {
        PartialWindowMatrix costMatrix = new PartialWindowMatrix(window);
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        Iterator matrixIterator = window.iterator();
        while (matrixIterator.hasNext()) {
            ColMajorCell currentCell = (ColMajorCell)matrixIterator.next();
            int i = currentCell.getCol();
            int j = currentCell.getRow();
            if (i == 0 && j == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(0)));
                continue;
            }
            if (i == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(j)) + costMatrix.get(i, j - 1));
                continue;
            }
            if (j == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(0)) + costMatrix.get(i - 1, j));
                continue;
            }
            double minGlobalCost = Math.min(costMatrix.get(i - 1, j), Math.min(costMatrix.get(i - 1, j - 1), costMatrix.get(i, j - 1)));
            costMatrix.put(i, j, minGlobalCost + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(j)));
        }
        return costMatrix.get(maxI, maxJ);
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ, SearchWindow window) {
        return DTW.constrainedTimeWarp(tsI, tsJ, window).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries tsI, TimeSeries tsJ, SearchWindow window) {
        return DTW.constrainedTimeWarp(tsI, tsJ, window);
    }

    private static TimeWarpInfo constrainedTimeWarp(TimeSeries tsI, TimeSeries tsJ, SearchWindow window) {
        WindowMatrix costMatrix = new WindowMatrix(window);
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        Iterator matrixIterator = window.iterator();
        while (matrixIterator.hasNext()) {
            ColMajorCell currentCell = (ColMajorCell)matrixIterator.next();
            int i = currentCell.getCol();
            int j = currentCell.getRow();
            if (i == 0 && j == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(0)));
                continue;
            }
            if (i == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(0), tsJ.getMeasurementVector(j)) + costMatrix.get(i, j - 1));
                continue;
            }
            if (j == 0) {
                costMatrix.put(i, j, DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(0)) + costMatrix.get(i - 1, j));
                continue;
            }
            double minGlobalCost = Math.min(costMatrix.get(i - 1, j), Math.min(costMatrix.get(i - 1, j - 1), costMatrix.get(i, j - 1)));
            costMatrix.put(i, j, minGlobalCost + DTW.euclideanDist(tsI.getMeasurementVector(i), tsJ.getMeasurementVector(j)));
        }
        double minimumCost = costMatrix.get(maxI, maxJ);
        WarpPath minCostPath = new WarpPath(maxI + maxJ - 1);
        int i = maxI;
        int j = maxJ;
        minCostPath.addFirst(i, j);
        while (i > 0 || j > 0) {
            double diagCost = i > 0 && j > 0 ? costMatrix.get(i - 1, j - 1) : Double.POSITIVE_INFINITY;
            double leftCost = i > 0 ? costMatrix.get(i - 1, j) : Double.POSITIVE_INFINITY;
            double downCost = j > 0 ? costMatrix.get(i, j - 1) : Double.POSITIVE_INFINITY;
            if (diagCost <= leftCost && diagCost <= downCost) {
                --i;
                --j;
            } else if (leftCost < diagCost && leftCost < downCost) {
                --i;
            } else if (downCost < diagCost && downCost < leftCost) {
                --j;
            } else if (i <= j) {
                --j;
            } else {
                --i;
            }
            minCostPath.addFirst(i, j);
        }
        costMatrix.freeMem();
        return new TimeWarpInfo(minimumCost, minCostPath);
    }

    private static double euclideanDist(double[] vector1, double[] vector2) {
        if (vector1.length != vector2.length) {
            throw new InternalError("ERROR:  cannot calculate the distance between vectors of different sizes.");
        }
        double sqSum = 0.0;
        for (int x = 0; x < vector1.length; ++x) {
            double diff = vector1[x] - vector2[x];
            sqSum += diff * diff;
        }
        return Math.sqrt(sqSum);
    }
}

