/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw.dtw;

import net.sf.javaml.distance.fastdtw.dtw.SearchWindow;
import net.sf.javaml.distance.fastdtw.timeseries.TimeSeries;

public class ParallelogramWindow
extends SearchWindow {
    public ParallelogramWindow(TimeSeries tsI, TimeSeries tsJ, int searchRadius) {
        super(tsI.size(), tsJ.size());
        double upperCornerI = Math.max((double)this.maxI() / 2.0 - (double)searchRadius * ((double)this.maxI() / (double)this.maxJ()), (double)this.minI());
        double upperCornerJ = Math.min((double)this.maxJ() / 2.0 + (double)searchRadius * ((double)this.maxJ() / (double)this.maxI()), (double)this.maxJ());
        double lowerCornerI = Math.min((double)this.maxI() / 2.0 + (double)searchRadius * ((double)this.maxI() / (double)this.maxJ()), (double)this.maxI());
        double lowerCornerJ = Math.max((double)this.maxJ() / 2.0 - (double)searchRadius * ((double)this.maxJ() / (double)this.maxI()), (double)this.minJ());
        for (int i = 0; i < tsI.size(); ++i) {
            int minJ;
            double interpRatio;
            int maxJ;
            double interpRatio2;
            boolean isIlargest;
            boolean bl = isIlargest = tsI.size() >= tsJ.size();
            if ((double)i < upperCornerI) {
                if (isIlargest) {
                    interpRatio2 = (double)i / upperCornerI;
                    maxJ = (int)Math.round(interpRatio2 * upperCornerJ);
                } else {
                    interpRatio2 = (double)(i + 1) / upperCornerI;
                    maxJ = (int)Math.round(interpRatio2 * upperCornerJ) - 1;
                }
            } else if (isIlargest) {
                interpRatio2 = ((double)i - upperCornerI) / ((double)this.maxI() - upperCornerI);
                maxJ = (int)Math.round(upperCornerJ + interpRatio2 * ((double)this.maxJ() - upperCornerJ));
            } else {
                interpRatio2 = ((double)(i + 1) - upperCornerI) / ((double)this.maxI() - upperCornerI);
                maxJ = (int)Math.round(upperCornerJ + interpRatio2 * ((double)this.maxJ() - upperCornerJ)) - 1;
            }
            if ((double)i <= lowerCornerI) {
                interpRatio = (double)i / lowerCornerI;
                minJ = (int)Math.round(interpRatio * lowerCornerJ);
            } else {
                interpRatio = ((double)i - lowerCornerI) / ((double)this.maxI() - lowerCornerI);
                minJ = (int)Math.round(lowerCornerJ + interpRatio * ((double)this.maxJ() - lowerCornerJ));
            }
            super.markVisited(i, minJ);
            super.markVisited(i, maxJ);
        }
    }
}

