/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.ensemble;

import java.util.Random;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.featureselection.FeatureRanking;
import net.sf.javaml.utils.ArrayUtils;

public class LinearRankingEnsemble
implements FeatureRanking {
    private FeatureRanking[] aes;
    private Random rg;
    private int[] ranking;

    public LinearRankingEnsemble(FeatureRanking[] aes) {
        this(aes, new Random(System.currentTimeMillis()));
    }

    public LinearRankingEnsemble(FeatureRanking[] aes, Random rg) {
        this.aes = aes;
        this.rg = rg;
    }

    @Override
    public void build(Dataset data) {
        int numAtt = data.noAttributes();
        double[] sum = new double[numAtt];
        for (FeatureRanking ae : this.aes) {
            DefaultDataset bootstrapData = new DefaultDataset();
            while (bootstrapData.size() < data.size()) {
                int random = this.rg.nextInt(data.size());
                bootstrapData.add((Instance)data.get(random));
            }
            Dataset copy = bootstrapData.copy();
            ae.build(copy);
            for (int i = 0; i < numAtt; ++i) {
                int n = i;
                sum[n] = sum[n] + (double)ae.rank(i);
            }
        }
        this.toRank(sum);
    }

    private void toRank(double[] sum) {
        int[] order = ArrayUtils.sort(sum);
        this.ranking = new int[order.length];
        for (int i = 0; i < order.length; ++i) {
            this.ranking[order[i]] = i;
        }
    }

    @Override
    public int rank(int attIndex) {
        return this.ranking[attIndex];
    }

    @Override
    public int noAttributes() {
        return this.ranking.length;
    }
}

