/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.ranking;

import java.util.HashSet;
import libsvm.LibSVM;
import libsvm.SelfOptimizingLinearLibSVM;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.featureselection.FeatureRanking;
import net.sf.javaml.filter.RemoveAttributes;
import net.sf.javaml.utils.ArrayUtils;

public class RecursiveFeatureEliminationSVM
implements FeatureRanking {
    private int[] ranking;
    private double removePercentage = 0.2;
    private int internalFolds;
    private boolean optimize;

    public RecursiveFeatureEliminationSVM(double removePercentage) {
        this(removePercentage, false);
    }

    public RecursiveFeatureEliminationSVM(double removePercentage, boolean optimize) {
        this(removePercentage, optimize, 4);
    }

    public RecursiveFeatureEliminationSVM(double removePercentage, boolean optimize, int internalFolds) {
        this.removePercentage = removePercentage;
        this.optimize = optimize;
        this.internalFolds = internalFolds;
    }

    @Override
    public void build(Dataset data) {
        int[] ordering = new int[data.noAttributes()];
        boolean[] removedAttributes = new boolean[data.noAttributes()];
        int removed = 0;
        while (data.noAttributes() > 1) {
            int i;
            LibSVM svm2;
            Dataset training = data;
            if (this.optimize) {
                svm2 = new SelfOptimizingLinearLibSVM(-4, 4, this.internalFolds);
            } else {
                svm2 = new LibSVM();
                svm2.getParameters().C = 1.0;
            }
            svm2.buildClassifier(training);
            double[] weights = svm2.getWeights();
            ArrayUtils.abs(weights);
            int[] order = ArrayUtils.sort(weights);
            int numRemove = (int)((double)order.length * this.removePercentage + 1.0);
            if (numRemove > order.length) {
                numRemove = order.length - 1;
            }
            HashSet<Integer> toRemove = new HashSet<Integer>();
            int[] trueIndices = new int[numRemove];
            for (i = 0; i < numRemove; ++i) {
                toRemove.add(order[i]);
                trueIndices[i] = this.getTrueIndex(order[i], removedAttributes);
                ordering[ordering.length - removed - 1] = trueIndices[i];
                ++removed;
            }
            for (i = 0; i < numRemove; ++i) {
                removedAttributes[trueIndices[i]] = true;
            }
            RemoveAttributes filter = new RemoveAttributes(toRemove);
            DefaultDataset filtered = new DefaultDataset();
            for (Instance i2 : data) {
                filter.filter(i2);
                filtered.add(i2);
            }
            data = filtered;
        }
        int index = 0;
        if (data.noAttributes() == 1) {
            for (int i = 0; i < removedAttributes.length; ++i) {
                if (removedAttributes[i]) continue;
                index = i;
            }
            ordering[0] = index;
        }
        this.ranking = new int[ordering.length];
        for (int i = 0; i < this.ranking.length; ++i) {
            this.ranking[ordering[i]] = i;
        }
    }

    private int getTrueIndex(int i, boolean[] removedAttributes) {
        int index = 0;
        while (i >= 0) {
            if (!removedAttributes[index]) {
                --i;
            }
            ++index;
        }
        return index - 1;
    }

    @Override
    public int rank(int attIndex) {
        return this.ranking[attIndex];
    }

    @Override
    public int noAttributes() {
        return this.ranking.length;
    }
}

