/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.scoring;

import java.util.Vector;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.featureselection.FeatureScoring;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.filter.discretize.EqualWidthBinning;
import net.sf.javaml.utils.ContingencyTables;

public class GainRatio
implements FeatureScoring {
    private Dataset training;
    private int bins = 10;

    @Override
    public void build(Dataset data) {
        EqualWidthBinning discretize = new EqualWidthBinning(this.bins);
        ((AbstractFilter)discretize).filter(data);
        this.training = data;
    }

    @Override
    public double score(int attribute) {
        double[][] counts = new double[this.bins][this.training.classes().size()];
        Vector<Object> classes = new Vector<Object>();
        classes.addAll(this.training.classes());
        for (Instance inst : this.training) {
            double[] dArray = counts[(int)inst.value(attribute)];
            int n = classes.indexOf(inst.classValue());
            dArray[n] = dArray[n] + 1.0;
        }
        return ContingencyTables.gainRatio(counts);
    }

    @Override
    public int noAttributes() {
        return this.training.noAttributes();
    }
}

